<?php

# IS_ISI
define('ISF_RES_0',			1);		// bit 0		- spare
define('ISF_RES_1',			2);		// bit 1		- spare
define('ISF_LOCAL',			4);		// bit 2		- guest or single player
define('ISF_MSO_COLS',		8);		// bit 3		- keep colours in MSO text
define('ISF_NLP',			16);	// bit 4		- receive NLP packets
define('ISF_MCI',			32);	// bit 5		- receive MCI packets

# ENUM	// the second byte of any packet is one of these
define('ISP_NONE',			0);		// not used
define('ISP_ISI',			1);		// instruction	- insim initialise
define('ISP_VER',			2);		// info			- version info
define('ISP_TINY',			3);		// both ways	- multi purpose
define('ISP_SMALL',			4);		// both ways	- multi purpose
define('ISP_STA',			5);		// info			- state info
define('ISP_SCH',			6);		// instruction	- single character
define('ISP_SFP',			7);		// instruction	- state flags pack
define('ISP_SCC',			8);		// instruction	- set car camera
define('ISP_CPP',			9);		// both ways	- cam pos pack
define('ISP_ISM',			10);	// info			- start multiplayer
define('ISP_MSO',			11);	// info			-  message out
define('ISP_III',			12);	// info			- hidden /i message
define('ISP_MST',			13);	// instruction	- type message or /command
define('ISP_MTC',			14);	// instruction	- message to a connection
define('ISP_MOD',			15);	// instruction	- set screen mode
define('ISP_VTN',			16);	// info			- vote notification
define('ISP_RST',			17);	// info			- race start
define('ISP_NCN',			18);	// info			- new connection
define('ISP_CNL',			19);	// info			- connection left
define('ISP_CPR',			20);	// info			- connection renamed
define('ISP_NPL',			21);	// info			- new player (joined race)
define('ISP_PLP',			22);	// info			- player pit (keeps slot in race)
define('ISP_PLL',			23);	// info			- player leave (spectate - loses slot)
define('ISP_LAP',			24);	// info			- lap time
define('ISP_SPX',			25);	// info			- split x time
define('ISP_PIT',			26);	// info			- pit stop start
define('ISP_PSF',			27);	// info			- pit stop finish
define('ISP_PLA',			28);	// info			- pit lane enter / leave
define('ISP_CCH',			29);	// info			- camera changed
define('ISP_PEN',			30);	// info			- penalty given or cleared
define('ISP_TOC',			31);	// info			- take over car
define('ISP_FLG',			32);	// info			- flag (yellow or blue)
define('ISP_PFL',			33);	// info			- player flags (help flags)
define('ISP_FIN',			34);	// info			- finished race
define('ISP_RES',			35);	// info			- result confirmed
define('ISP_REO',			36);	// both ways	- reorder (info or instruction)
define('ISP_NLP',			37);	// info			- node and lap packet
define('ISP_MCI',			38);	// info			- multi car info
define('ISP_MSX',			39);	// instruction	- type message
define('ISP_MSL',			40);	// instruction	- message to local computer
define('ISP_CRS',			41);	// info			- car reset
define('ISP_BFN',			42);	// both ways	- delete buttons / receive button requests
define('ISP_AXI',			43);	// info			- autocross layout information
define('ISP_AXO',			44);	// info			- hit an autocross object
define('ISP_BTN',			45);	// instruction	- show a button on local or remote screen
define('ISP_BTC',			46);	// info			- sent when a user clicks a button
define('ISP_BTT',			47);	// info			- sent after typing into a button
define('ISP_RIP',			48);	// both ways	- replay information packet
define('ISP_SSH',			49);	// both ways	- screenshot

# ENUM	// the fourth byte of an IS_TINY packet is one of these
define('TINY_NONE',			0);		// keep alive	- see "maintaining the connection"
define('TINY_VER',			1);		// info request	- get version
define('TINY_CLOSE',		2);		// instruction	- close insim
define('TINY_PING',			3);		// ping request	- external progam requesting a reply
define('TINY_REPLY',		4);		// ping reply	- reply to a ping request
define('TINY_VTC',			5);		// info			- vote cancelled
define('TINY_SCP',			6);		// info request	- send camera pos
define('TINY_SST',			7);		// info request	- send state info
define('TINY_GTH',			8);		// info request	- get time in hundredths (i.e. SMALL_RTP)
define('TINY_MPE',			9);		// info			- multi player end
define('TINY_ISM',			10);	// info request	- get multiplayer info (i.e. ISP_ISM)
define('TINY_REN',			11);	// info			- race end (return to game setup screen)
define('TINY_CLR',			12);	// info			- all players cleared from race
define('TINY_NCN',			13);	// info request	- get all connections
define('TINY_NPL',			14);	// info request	- get all players
define('TINY_RES',			15);	// info request	- get all results
define('TINY_NLP',			16);	// info request	- send an IS_NLP
define('TINY_MCI',			17);	// info request	- send an IS_MCI
define('TINY_REO',			18);	// info request	- send an IS_REO
define('TINY_RST',			19);	// info request	- send an IS_RST
define('TINY_AXI',			20);	// info request	- send an IS_AXI - AutoX Info
define('TINY_AXC',			21);	// info			- autocross cleared
define('TINY_RIP',			22);	// info request	- send an IS_RIP - Replay Information Packet

# ENUM	// the fourth byte of an IS_SMALL packet is one of these
define('SMALL_NONE',		0);		// not used
define('SMALL_SSP',			1);		// instruction	- start sending positions
define('SMALL_SSG',			2);		// instruction	- start sending gauges
define('SMALL_VTA',			3);		// report		- vote action
define('SMALL_TMS',			4);		// instruction	- time stop
define('SMALL_STP',			5);		// instruction	- time step
define('SMALL_RTP',			6);		// info			- race time packet (reply to GTH)
define('SMALL_NLI',			7);		// instruction	- set node lap interval

# IS_STA
define('ISS_GAME',			1);		// in game (or MPR)
define('ISS_REPLAY',		2);		// in SPR
define('ISS_PAUSED',		4);		// paused
define('ISS_SHIFTU',		8);		// SHIFT+U mode
define('ISS_SHIFTU_HIGH',	16);	// HIGH view
define('ISS_SHIFTU_FOLLOW',	32);	// following car
define('ISS_SHIFTU_NO_OPT',	64);	// SHIFT+U buttons hidden
define('ISS_SHOW_2D',		128);	// showing 2d display
define('ISS_FRONT_END',		256);	// entry screen
define('ISS_MULTI',			512);	// multiplayer mode
define('ISS_MPSPEEDUP',		1024);	// multiplayer speedup option
define('ISS_WINDOWED',		2048);	// LFS is running in a window
define('ISS_SOUND_MUTE',	4096);	// sound is switched off
define('ISS_VIEW_OVERRIDE',	8192);	// override user view
define('ISS_VISIBLE',		16384);	// InSim buttons visible

# IS_SFP	/!\ SPECIAL CASE /!\
define('SFP_SHIFTU_FOLLOW',	1);		// following car
define('SFP_SHIFTU_NO_OPT',	2);		// SHIFT+U buttons hidden
define('SFP_SHOW_2D',		3);		// showing 2d display
define('SFP_MPSPEEDUP',		4);		// multiplayer speedup option
define('SFP_SOUND_MUTE',	5);		// sound is switched off

# IS_MSO ENUM // User Values UserType byte
define('MSO_SYSTEM',		0);		// system message
define('MSO_USER',			1);		// normal visible user message
define('MSO_PREFIX',		2);		// hidden message starting with special prefix (see ISI)
define('MSO_O',				3);		// hidden message typed on local pc with /o command
define('MSO_NUM',			4);		// 

# IS_MSL ENUM // Message Sounds Sound byte
define('SND_SILENT',		0);		// 
define('SND_MESSAGE',		1);		// 
define('SND_SYSMESSAGE',	2);		// 
define('SND_INVALIDKEY',	3);		// 
define('SND_ERROR',			4);		// 
define('SND_NUM',			5);		// 

# IS_VTN ENUM // VoTe Notify Action byte
define('VOTE_NONE',			0);		// no vote
define('VOTE_END',			1);		// end race
define('VOTE_RESTART',		2);		// restart
define('VOTE_QUALIFY',		3);		// qualify
define('VOTE_NUM',			4);

# IS_NPL // Setup flags SetF byte
define('SETF_SYMM_WHEELS',	1);		// 
define('SETF_TC_ENABLE',	2);		// 
define('SETF_ABS_ENABLE',	4);		// 

# IS_PLA ENUM // Pitlane Fact byte
define('PITLANE_EXIT',		0);		// left pit lane
define('PITLANE_ENTER',		1);		// entered pit lane
define('PITLANE_NO_PURPOSE',2);		// entered for no purpose
define('PITLANE_DT',		3);		// entered for drive-through
define('PITLANE_SG',		4);		// entered for stop-go
define('PITLANE_NUM',		5);		// 

# IS_PLA // Pitlane Flag byte
define('PSE_NOTHING',		1);		// bit 0 (1)
define('PSE_STOP',			2);		// bit 1 (2)
define('PSE_FR_DAM',		4);		// bit 2 (4)
define('PSE_FR_WHL',		8);		// bit 3
define('PSE_LE_FR_DAM',		16);	// bit 4
define('PSE_LE_FR_WHL',		32);	// bit 5
define('PSE_RI_FR_DAM',		64);	// bit 6
define('PSE_RI_FR_WHL',		128);	// bit 7
define('PSE_RE_DAM',		256);	// bit 8
define('PSE_RE_WHL',		512);	// bit 9
define('PSE_LE_RE_DAM',		1024);	// bit 10
define('PSE_LE_RE_WHL',		2048);	// bit 11
define('PSE_RI_RE_DAM',		4096);	// bit 12
define('PSE_RI_RE_WHL',		8192);	// bit 13
define('PSE_BODY_MINOR',	16384);	// bit 14
define('PSE_BODY_MAJOR',	32768);	// bit 15
define('PSE_SETUP',			65536);	// bit 16
define('PSE_REFUEL',		131072);// bit 17
define('PSE_NUM',			262144);// bit 18

# ENUM // View identifiers IS_CCH->Camera & IS_STA->InGameCam byte
define('VIEW_FOLLOW',		0);		// arcade
define('VIEW_HELI',			1);		// helicopter
define('VIEW_CAM',			2);		// tv camera
define('VIEW_DRIVER',		3);		// cockpit
define('VIEW_CUSTOM',		4);		// custom
define('VIEW_MAX',			5);		//
define('VIEW_ANOTHER',		255);	// viewing another car

# ENUM // Leave Reasion, IS_CNL->Reason
define('LEAVR_DISCO',		0);		// disconnect
define('LEAVR_TIMEOUT',		1);		// timed out
define('LEAVR_LOSTCONN',	2);		// lost connection
define('LEAVR_KICKED',		3);		// kicked
define('LEAVR_BANNED',		4);		// banned
define('LEAVR_SECURITY',	5);		// OOS or cheat protection
define('LEAVR_NUM',			6);		// 

# ENUM // Penalty values IS_PEN->NewPen&OldPen, IS_PIT->Penalty, IS_SPX->Penalty, IS_LAP->Penalty
define('PENALTY_NONE',		0);		// 0		
define('PENALTY_DT',		1);		// 1
define('PENALTY_DT_VALID',	2);		// 2
define('PENALTY_SG',		3);		// 3
define('PENALTY_SG_VALID',	4);		// 4
define('PENALTY_30',		5);		// 5
define('PENALTY_45',		6);		// 6
define('PENALTY_NUM',		7);		// 

# ENUM // Penalty reasons IS_PEN->Reason
define('PENR_UNKNOWN',		0);		// unknown or cleared penalty
define('PENR_ADMIN',		1);		// penalty given by admin
define('PENR_WRONG_WAY',	2);		// wrong way driving
define('PENR_FALSE_START',	3);		// starting before green light
define('PENR_SPEEDING',		4);		// speeding in pit lane
define('PENR_STOP_SHORT',	5);		// stop-go pit stop too short
define('PENR_STOP_LATE',	6);		// compulsory stop is too late
define('PENR_NUM',			7);		//  

# ENUM // Player Flags IS_RES->Flags, IS_FIN->Flags, IS_PFL->Flags, IS_PIT->Flags, IS_LAP->Flags, IS_NPL->Flags
define('PIF_SWAPSIDE',		1);		// 
define('PIF_RESERVED_2',	2);		// 
define('PIF_RESERVED_4',	4);		// 
define('PIF_AUTOGEARS',		8);		// 
define('PIF_SHIFTER',		16);	// 
define('PIF_RESERVED_32',	32);	// 
define('PIF_HELP_B',		64);	// 
define('PIF_AXIS_CLUTCH',	128);	// 
define('PIF_INPITS',		256);	// 
define('PIF_AUTOCLUTCH',	512);	// 
define('PIF_MOUSE',			1024);	// 
define('PIF_KB_NO_HELP',	2048);	// 
define('PIF_KB_STABILISED',	4096);	// 
define('PIF_CUSTOM_VIEW',	8192);	// 

# ENUM // Tyre compounds IS_PIT->Flags, IS_NPL->Tyres
define('TYRE_R1',			0);		// 0
define('TYRE_R2',			1);		// 1
define('TYRE_R3',			2);		// 2
define('TYRE_R4',			3);		// 3
define('TYRE_ROAD_SUPER',	4);		// 4
define('TYRE_ROAD_NORMAL',	5);		// 5
define('TYRE_HYBRID',		6);		// 6
define('TYRE_KNOBBLY',		7);		// 7
define('TYRE_NUM',			8);		// 
define('NOT_CHANGED', 		255);	// 

# Confirmation flags // IS_RES->Confirm, IS_FIN->Confirm, 
define('CONF_MENTIONED',	1);		// 
define('CONF_CONFIRMED',	2);		// 
define('CONF_PENALTY_DT',	4);		// 
define('CONF_PENALTY_SG',	8);		// 
define('CONF_PENALTY_30',	16);	// 
define('CONF_PENALTY_45',	32);	// 
define('CONF_DID_NOT_PIT',	64);	// 
define('CONF_DISQ',			76);	// CONF_PENALTY_DT | CONF_PENALTY_SG | CONF_DID_NOT_PIT
define('CONF_TIME',			48);	// CONF_PENALTY_30 | CONF_PENALTY_45

# Race flags // IS_RST->Flags, 
define('HOSTF_CAN_VOTE',	1);		// 
define('HOSTF_CAN_SELECT',	2);		// 
define('HOSTF_MID_RACE',	32);	// 
define('HOSTF_MUST_PIT',	64);	// 
define('HOSTF_CAN_RESET',	128);	// 
define('HOSTF_FCV',			256);	// 
define('HOSTF_CRUISE',		512);	// 

/* PASSANGER BYTE! // IS_NPL->Pass, 
	bit 0 female
	bit 1 front
	bit 2 female
	bit 3 rear left
	bit 4 female
	bit 5 rear middle
	bit 6 female
	bit 7 rear right
*/

# CompCar struct Info byte IS_MCI->CompCar-Info
define('CCI_BLUE',			1);		// this car is in the way of a driver who is a lap ahead
define('CCI_YELLOW',		2);		// this car is slow or stopped and in a dangerous place
define('CCI_LAG',			32);	// this car is lagging (missing or delayed position packets)
define('CCI_FIRST',			64);	// this is the first compcar in this set of MCI packets
define('CCI_LAST',			128);	// this is the last compcar in this set of MCI packets

# Error codes // IS_RIP Error byte
define('RIP_OK',			0);		// OK : completed instruction
define('RIP_ALREADY',		1);		// OK : already at the destination
define('RIP_DEDICATED',		2);		// can't run a replay - dedicated host
define('RIP_WRONG_MODE',	3);		// can't start a replay - not in a suitable mode
define('RIP_NOT_REPLAY',	4);		// RName is zero but no replay is currently loaded
define('RIP_CORRUPTED',		5);		// IS_RIP corrupted (e.g. RName does not end with zero)
define('RIP_NOT_FOUND',		6);		// the replay file was not found
define('RIP_UNLOADABLE',	7);		// obsolete / future / corrupted
define('RIP_DEST_OOB',		8);		// destination is beyond replay length
define('RIP_UNKNOWN',		9);		// unknown error found starting replay
define('RIP_USER',			10);	// replay search was terminated by user
define('RIP_OOS',			11);	// can't reach destination - SPR is out of sync

# various options // IS_RIP Options byte
define('RIPOPT_LOOP',		1);
define('RIPOPT_SKINS',		2);

# Error codes // IS_SSH Error byte
define('SSH_OK',			0);		//  0 - OK : completed instruction
define('SSH_DEDICATED',		1);		//  1 - can't save a screenshot - dedicated host
define('SSH_CORRUPTED',		2);		//  2 - IS_SSH corrupted (e.g. BMP does not end with zero)
define('SSH_NO_SAVE',		3);		//  3 - could not save the screenshot

# Button FunctioN subtype ENUM // IS_BFN SubT byte
define('BFN_DEL_BTN',		0);		//  instruction		-	delete one button (must set ClickID)
define('BFN_CLEAR',			1);		//  instruction		-	clear all buttons made by this insim instance
define('BFN_USER_CLEAR',	2);		//  info			-	user cleared this insim instance's buttons
define('BFN_REQUEST',		3);		//  user request	-	SHIFT+B or SHIFT+I - request for buttons

# Value returned in IS_BTC and IS_BTT // IS_BTC->Inst and IS_BTT->Inst
define('INST_ALWAYS_ON',	128);	// if this bit is set the button is visible in all screens

# style flags for the button // IS_BTN->BStyle
define('ISB_C1',			1);		// you can choose a standard
define('ISB_C2',			2);		// interface colour using
define('ISB_C4',			4);		// these 3 lowest bits - see below
# Color for the ISB_C1,ISB_C2,ISB_C3 bits
define('c_light_grey', 		0); 	// light grey		(not user editable)
define('c_title_colour',	1);		// (default:yellow)
define('c_unselected_text',	2);		// (default:black)
define('c_selected_text',	3);		// (default:white)
define('c_ok',				4);		// (default:green)
define('c_cancel',			5);		// (default:red)
define('c_text_string',		6);		// (default:pale blue)
define('c_unavailable',		7);		// (default:grey)
define('ISB_CLICK',			8);		// click this button to send IS_BTC
define('ISB_LIGHT',			16);	// light button
define('ISB_DARK',			32);	// dark button
define('ISB_LEFT',			64);	// align text to left
define('ISB_RIGHT',			128);	// align text to right

# click flags // IS_BTC CFlags byte
define('ISB_LMB',			1);		// left click
define('ISB_RMB',			2);		// right click
define('ISB_CTRL',			4);		// ctrl + click
define('ISB_SHIFT',			8);		// shift + click

?>