package lfstrackdatatesting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;

import lfstrackdatatesting.drawtrack.DrawTrack;

public class PTHFileTesting {
	public PTHFileTesting() {
		try {
			// Use pth files from smx dir
			TrackData track = readPTHFile("AS1.pth");
			
			if(track != null) {
				new DrawTrack(track);
			} else {
				print("!! read unsuccessful");
			}
		} catch(FileNotFoundException fnfe) {
			fnfe.printStackTrace();
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
	}
	
	/*
	 * Read the PTH file with the given filename
	 * From the InSim.txt file:
	 * 
	 * 	// char			1-byte character
	 *	// byte			1-byte unsigned integer
	 *	// word			2-byte unsigned integer
	 *	// short		2-byte signed integer
	 *	// unsigned		4-byte unsigned integer
	 *	// int			4-byte signed integerz
	 *	// float		4-byte float
	 */
	private TrackData readPTHFile(String filename) throws FileNotFoundException, IOException {
		print("readPTHFile called with filename: "+filename);
		
		FileChannel fc = new FileInputStream("PTH"+File.separatorChar+filename).getChannel();
		ByteBuffer buff = fc.map(MapMode.READ_ONLY, 0, fc.size());
		buff.order(ByteOrder.LITTLE_ENDIAN);

		int nodeCount;
		int finishNode;
		
		TrackData newTrack = null;

		byte[] typeBytes = new byte[6];
		
		buff.get(typeBytes, 0, 6);
		
		String fileType = new String(typeBytes);

		print("fileType: "+fileType);

		if (!fileType.equals("LFSPTH")) {
			print("Invalid FileType map");
			return null;
		} 

		if (buff.get() > 0) {
			print("Invalid Version");
			return null;
		}

		if (buff.get() > 0) {
			print("Invalid Revision");
			return null;
		}

		nodeCount = buff.getInt();

		print("nodeCount: "+nodeCount);

		finishNode = buff.getInt();

		print("finishNode: "+finishNode);

		print("\nGoing to read nodes...");

		String trackName = filename.contains(".pth") ? 
				filename.substring(0, filename.indexOf(".pth")) : "";

		newTrack = new TrackData(trackName);

		print("creating new track with name: "+trackName);

		for(int nodeIndex=0; nodeIndex<nodeCount; nodeIndex++) {
			print("nodeIndex: "+nodeIndex);

			int centreX = buff.getInt();
			int centreY = buff.getInt();
			int centreZ = buff.getInt();

			print("centreX: "+centreX+", centreY: "+centreY+", centreZ: "+centreZ);

			float directionX = buff.getFloat();
			float directionY = buff.getFloat();
			float directionZ = buff.getFloat();

			print("directionX: "+directionX+", directionY: "+directionY+", directionZ: "+directionZ);

			float limitLeft = buff.getFloat();
			float limitRight = buff.getFloat();

			print("limitLeft: "+limitLeft+", limitRight: "+limitRight);

			float driveLeft = buff.getFloat();
			float driveRight = buff.getFloat();

			print("driveLeft: "+driveLeft+", driveRight: "+driveRight);

			newTrack.addOneNode(new OneNode(nodeIndex, centreX, centreY, centreZ, 
					directionX, directionY, directionZ, limitLeft, limitRight, 
					driveLeft, driveRight));
		}

		print("Track Name: "+newTrack.getTrackName()+", length: "+newTrack.getTrackLength()+"m");

		return newTrack;
	}
	
	private void print(String msg) {
		System.out.println(msg);
	}
	
	public static void main(String[] args) {
		new PTHFileTesting();
	}
}