Sub OnLapperStart_Pitboard()

	### Pitboard ####
	GlobalVar $user_array;
	GlobalVar $pitboard_offset;
	Globalvar $pitboard_hight;
	GlobalVar $splits_value;
	GlobalVar $safetycar_status;
	GlobalVar $safetycar_message_1;
	GlobalVar $safetycar_message_2;
	GlobalVar $safetycar_message_3;
	GlobalVar $qualify;
	$pitboard_offset="";
	$pitboard_hight="";
	$splits_value="";
	$safetycar_status="off";
	$safetycar_message_1="";
	$safetycar_message_2="";
	$safetycar_message_3="";
	$qualify="off";
	### End ###

	### Pitwindow GUI ###
	GlobalVar $left_right_pw_gui;
	GlobalVar $top_bottom_pw_gui;
	GlobalVar $number_of_windows;
	GlobalVar $number_of_stops_w1;
	GlobalVar $number_of_stops_w2;
	GlobalVar $number_of_stops_w3;
	GlobalVar $penalty_laps;
	GlobalVar $force_tyre_change;
	GlobalVar $start_window_1;
	GlobalVar $end_window_1;
	GlobalVar $start_window_2;
	GlobalVar $end_window_2;
	GlobalVar $start_window_3;
	GlobalVar $end_window_3;
	$left_right_pw_gui=70;
	$top_bottom_pw_gui=70;
	$number_of_windows="";
	$number_of_stops_w1="";
	$number_of_stops_w2="";
	$number_of_stops_w3="";
	$penalty_laps="";
	$force_tyre_change="No";
	$start_window_1="";
	$end_window_1="";
	$start_window_2="";
	$end_window_2="";
	$start_window_3="";
	$end_window_3="";
	### End ###
	
EndSub

Sub OnConnect_Pitboard() # Player event

	### Add UserName to $user_array together with $number_of_stops ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == "")
		THEN
		  $user_array[$i,1] = GetCurrentPlayerVar( "UserName" );
		  $user_array[$i,2] = $number_of_stops_w1;
		  $user_array[$i,3] = $number_of_stops_w2;
		  $user_array[$i,4] = $number_of_stops_w3;
		  $user_array[$i,5] = GetCurrentPlayerVar( "Nickname" ); # Store Nickname to be used in the !connected event
		  $user_array[$i,6] = 1; # Initial value for player status (0 = ready , 1 = not ready , 2 = spectator)
		  $user_array[$i,7] = 0; # Initial value for pitlane exit (0 = not done , 1 = done)
		  $user_array[$i,8] = 0; # Initial value for start qualify (0 = not done , 1 = done)
		  BREAK;
		ENDIF
	ENDFOR
	### End ###

EndSub

Sub OnConnectClose_Pitboard()

	### Get UserName and search in storedvalue.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

	SetCurrentPlayerVar( "config_pb_display_mode_graphical",GetStoredValue( $userName . "config_pb_display_mode_graphical" ) );
	SetCurrentPlayerVar( "config_pb_display_mode_text",GetStoredValue( $userName . "config_pb_display_mode_text" ) );
	SetCurrentPlayerVar( "config_pb_display_mode_off",GetStoredValue( $userName . "config_pb_display_mode_off" ) );
	SetCurrentPlayerVar( "config_pb_practise",GetStoredValue( $userName . "config_pb_practise" ) );
	SetCurrentPlayerVar( "config_pb_race",GetStoredValue( $userName . "config_pb_race" ) );
	SetCurrentPlayerVar( "config_pb_race_gaps",GetStoredValue( $userName . "config_pb_race_gaps" ) );
	SetCurrentPlayerVar( "config_pb_race_splits",GetStoredValue( $userName . "config_pb_race_splits" ) );
	SetCurrentPlayerVar( "top_bottom_coordinate",GetStoredValue( $userName . "top_bottom_coordinate" ) );
	SetCurrentPlayerVar( "left_right_coordinate",GetStoredValue( $userName . "left_right_coordinate" ) );
	SetCurrentPlayerVar( "split_setting",GetStoredValue( $userName . "split_setting" ) );
	SetCurrentPlayerVar( "spb_setting",GetStoredValue( $userName . "spb_setting" ) );
	SetCurrentPlayerVar( "lost_gained_messages",GetStoredValue( $userName . "lost_gained_messages" ) );
	### End ###

	### Set default values if no values are loaded ###
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_display_mode_graphical","on" ); # Set default display mode graphical "on"
	ENDIF

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_display_mode_text","off" ); # Set default display mode text "off"
	ENDIF

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_off" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_display_mode_off","off" ); # Set default display mode off "off"
	ENDIF

	IF ( GetCurrentPlayerVar( "config_pb_practise" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_practise","on" ); # Set default practise "on"
	ENDIF
	
	IF ( GetCurrentPlayerVar( "config_pb_race" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_race","off" ); # Set default race "off"
	ENDIF

	IF ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_race_gaps","off" ); # Set default race gaps "off"
	ENDIF
	
	IF ( GetCurrentPlayerVar( "config_pb_race_splits" ) == "")
	THEN
	  SetCurrentPlayerVar( "config_pb_race_splits","off" ); # Set default race splits "off"
	ENDIF

	IF ( GetCurrentPlayerVar( "top_bottom_coordinate" ) == "")
	THEN
	  SetCurrentPlayerVar( "top_bottom_coordinate",70 ); # Set default top/bottom position to 70
	ENDIF

	IF ( GetCurrentPlayerVar( "left_right_coordinate" ) == "")
	THEN
	  SetCurrentPlayerVar( "left_right_coordinate",1 ); # Set default left/right position to 1
	ENDIF

	IF ( GetCurrentPlayerVar( "split_setting" ) == "")
	THEN
	  SetCurrentPlayerVar( "split_setting",150 ); # Set default yellow split setting to 150
	ENDIF

	IF ( GetCurrentPlayerVar( "spb_setting" ) == "")
	THEN
	  SetCurrentPlayerVar( "spb_setting","end" ); # Set default spb setting "end"
	ENDIF

	IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "")
	THEN
	  SetCurrentPlayerVar( "lost_gained_messages","no" ); # Set default lost/gained messages "no"
	ENDIF
	### End ###

	Config_Pitboard( $KeyFlags );

EndSub

Sub OnNewPlayerJoin_Pitboard()
	### Determine number of splits on current track and set corresponding offset value ###
	IF ( getLapperVar( "ShortTrackName" ) == "FE4" || getLapperVar( "ShortTrackName" ) == "FE4R" || getLapperVar( "ShortTrackName" ) == "AS6" || getLapperVar( "ShortTrackName" ) == "AS6R" || getLapperVar( "ShortTrackName" ) == "AS7" || getLapperVar( "ShortTrackName" ) == "AS7R")
	THEN
	  $pitboard_offset = 37;
	  $pitboard_hight = 50;
	  $splits_value= 4;
	ELSE
	  IF ( getLapperVar( "ShortTrackName" ) == "BL1" || getLapperVar( "ShortTrackName" ) == "BL1R" || getLapperVar( "ShortTrackName" ) == "BL1" || getLapperVar( "ShortTrackName" ) == "SO4" || getLapperVar( "ShortTrackName" ) == "SO4R" || getLapperVar( "ShortTrackName" ) == "SO5" || getLapperVar( "ShortTrackName" ) == "SO5R" || getLapperVar( "ShortTrackName" ) == "FE2" || getLapperVar( "ShortTrackName" ) == "FE2R" || getLapperVar( "ShortTrackName" ) == "FE3" || getLapperVar( "ShortTrackName" ) == "FE3R" || getLapperVar( "ShortTrackName" ) == "KY2" || getLapperVar( "ShortTrackName" ) == "KY2R" || getLapperVar( "ShortTrackName" ) == "KY3" || $ShortTrackName == "KY3R" || getLapperVar( "ShortTrackName" ) == "WE1" || getLapperVar( "ShortTrackName" ) == "WE1R" || getLapperVar( "ShortTrackName" ) == "AS4" || getLapperVar( "ShortTrackName" ) == "AS4R" || getLapperVar( "ShortTrackName" ) == "AS5" || getLapperVar( "ShortTrackName" ) == "AS5R")
	  THEN
	    $pitboard_offset = 29;
	    $pitboard_hight = 42;
	    $splits_value= 3;
	  ELSE
	    IF ( getLapperVar( "ShortTrackName" ) == "BL2" || getLapperVar( "ShortTrackName" ) == "BL2R" || getLapperVar( "ShortTrackName" ) =="SO1" || getLapperVar( "ShortTrackName" ) == "SO1R" || getLapperVar( "ShortTrackName" ) == "SO2" || getLapperVar( "ShortTrackName" ) == "SO2R" || getLapperVar( "ShortTrackName" ) == "SO3"  || getLapperVar( "ShortTrackName" ) == "SO3R" || getLapperVar( "ShortTrackName" ) == "SO6" || getLapperVar( "ShortTrackName" ) == "SO6R" || getLapperVar( "ShortTrackName" ) == "FE1" || getLapperVar( "ShortTrackName" ) == "FE1R" || getLapperVar( "ShortTrackName" ) == "FE5" || getLapperVar( "ShortTrackName" ) == "FE5R" || getLapperVar( "ShortTrackName" ) == "FE6" || getLapperVar( "ShortTrackName" ) == "FE6R" || getLapperVar( "ShortTrackName" ) == "KY1" || getLapperVar( "ShortTrackName" ) == "KY1R" || getLapperVar( "ShortTrackName" ) == "AS1" || getLapperVar( "ShortTrackName" ) == "AS1R" || getLapperVar( "ShortTrackName" ) == "AS2" || getLapperVar( "ShortTrackName" ) == "AS2R" || getLapperVar( "ShortTrackName" ) == "AS3" || getLapperVar( "ShortTrackName" ) == "AS3R")
	    THEN
	      $pitboard_offset = 21;
	      $pitboard_hight = 42;
	      $splits_value= 2;
	    ENDIF
	  ENDIF
	ENDIF
	### End

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical") == "on" )
	THEN
	  ### Display:  Nickname, Start PW, End PW, Stops and their values ###
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,$pitboard_hight+4,5,-1,32,"");
	  ELSE
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,$pitboard_hight,5,-1,32,"");
	  ENDIF
	  openPrivButton( "pitboard_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+1,30,4,4,-1,0,"^7Pitboard:^0 " . GetCurrentPlayerVar( "Nickname" ) );
	  
	  openPrivButton( "pitboard_start_pitwindow",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^2Start PW:");
	  openPrivButton( "pitboard_end_pitwindow",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^1End PW:");
	  openPrivButton( "pitboard_pw_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^7Stops: ");
	ENDIF
EndSub

Sub OnDisConnect_Pitboard() # Player event

	### Search for UserName in $user_array and erase values when found ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  $user_array[$i,1] = "";
		  $user_array[$i,2] = "";
		  $user_array[$i,3] = "";
		  $user_array[$i,4] = "";
		  $user_array[$i,5] = "";
		  $user_array[$i,6] = "";
		  $user_array[$i,7] = "";
		  $user_array[$i,8] = "";
		  BREAK;
		ENDIF
	ENDFOR
	### End ###
	
EndSub

Sub OnNewGapPlayerBefore_Pitboard( $split )
	IF ( GetCurrentPlayerVar ( "left_right_coordinate") != -1 && GetCurrentPlayerVar ( "top_bottom_coordinate") != -1 )
	THEN
	  ### Check if UNameBefore is empty or not ### 
	  IF( GetCurrentPlayerVar( "UNameBefore" ) != "" )
	  THEN
	    ### Check if race is ON and splits is ON ###
	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" && ( GetCurrentPlayerVar( "config_pb_race_splits" ) == "on" ) )
	    THEN
	      SWITCH ($split)
		CASE 1:
			$splitnumber="1";
			$extra_tb=17;
		CASE 2:
			$splitnumber="2";
			$extra_tb=25;
		CASE 3:
			$splitnumber="3";
			$extra_tb=33;
		CASE 4:
			$splitnumber="Last";
			$extra_tb=$pitboard_offset+4;
	      ENDSWITCH

	      $Before_split=NumToMSH(GetPlayerVar( GetCurrentPlayerVar( "UNameBefore" ),"SectorSplit" . $splitnumber ));

	      IF ( $Before_split >  NumToMSH(GetCurrentPlayerVar( "SectorSplit" . $splitnumber )) )
	      THEN
	        $Before_split="^2".$Before_split;
	      ELSE
	        $Before_split="^1".$Before_split;
	      ENDIF

	      openPrivButton( "pitboard_before_sector_" . $splitnumber,GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$extra_tb,10,4,4,-1,16, $Before_split );
	    ### END ###
	    ELSE
	      ### Check if race is ON and gaps is ON ###
	      IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" && ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == "on" ) )
	      THEN
	        IF ($split == 1)
	        THEN
		  SetCurrentPlayerVar( "Before_gap_1", GetCurrentPlayerVar( "GapBefore" ) );
	          IF ( GetCurrentPlayerVar( "Before_gap_last" ) != "")
		  THEN
		    IF ( GetCurrentPlayerVar( "Before_gap_1" ) >= GetCurrentPlayerVar( "Before_gap_last" ) )
		    THEN
		      openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_1" ) );
		    ELSE
		      openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_1" ) );
		    ENDIF
		  ELSE
		    openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . GetCurrentPlayerVar( "Before_gap_1" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 2)
	        THEN
		  SetCurrentPlayerVar( "Before_gap_2", GetCurrentPlayerVar( "GapBefore" ) );
		  IF ( GetCurrentPlayerVar( "Before_gap_2" ) >= GetCurrentPlayerVar( "Before_gap_1" ) )
		  THEN
		    openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_2" ) );
		  ELSE
		    openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_2" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 3)
	        THEN
		  SetCurrentPlayerVar( "Before_gap_3", GetCurrentPlayerVar( "GapBefore" ) );
		  IF ( GetCurrentPlayerVar( "Before_gap_3" ) >= GetCurrentPlayerVar( "Before_gap_2" ) )
		  THEN
		    openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_3" ) );
		  ELSE
		    openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_3" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 4)
	        THEN
		  SetCurrentPlayerVar( "Before_gap_last", GetCurrentPlayerVar( "GapBefore" ) );
		  IF ( $splits_value == 4 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_3" ))
		    THEN
		      $Color_gap_before="^1";
		    ELSE
		      $Color_gap_before="^2";
		    ENDIF
		  ENDIF

		  IF ( $splits_value == 3 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_2" ) )
		    THEN
		      $Color_gap_before="^1";
		    ELSE
		      $Color_gap_before="^2";
		    ENDIF
		  ENDIF

		  IF ( $splits_value == 2 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_1" ) )
		    THEN
		      $Color_gap_before="^1";
		    ELSE
		      $Color_gap_before="^2";
		    ENDIF
		  ENDIF

		  openPrivButton( "pitboard_before_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_gap_before . GetCurrentPlayerVar( "Before_gap_last" ) );
	        ENDIF
	      ENDIF
	      ### END ###
	    ENDIF
	  ELSE
	    ### Check if race is ON ###
	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" )
	    THEN
	      IF ($split == 1)
	      THEN
	        openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 2)
	      THEN
	        openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 3)
	      THEN
	       openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 4)
	      THEN
	        openPrivButton( "pitboard_before_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"" );
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
EndSub

Sub OnNewGapPlayerBehind_Pitboard( $split )
	IF ( GetCurrentPlayerVar ( "left_right_coordinate") != -1 && GetCurrentPlayerVar ( "top_bottom_coordinate") != -1 )
	THEN
	  ### Check if UNameBehind is empty or not ###
	  IF( GetCurrentPlayerVar( "UNameBehind" ) != "" )
	  THEN
	    ### Check if race is ON and splits is ON ###
	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" && ( GetCurrentPlayerVar( "config_pb_race_splits" ) == "on" ) )
	    THEN
	      SWITCH ($split)
		CASE 1:
			$splitnumber="1";
			$extra_tb=17;
		CASE 2:
			$splitnumber="2";
			$extra_tb=25;
		CASE 3:
			$splitnumber="3";
			$extra_tb=33;
		CASE 4:
			$splitnumber="Last";
			$extra_tb=$pitboard_offset+4;
	      ENDSWITCH

	      $Behind_split=NumToMSH(GetPlayerVar( GetCurrentPlayerVar( "UNameBehind" ),"SectorSplit" . $splitnumber ));

	      IF ( $Behind_split >  NumToMSH(GetCurrentPlayerVar( "SectorSplit" . $splitnumber )) )
	      THEN
	        $Behind_split="^2".$Behind_split;
	      ELSE
	        $Behind_split="^1".$Behind_split;
	      ENDIF

	      openPrivButton( "pitboard_behind_sector_" . $splitnumber,GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$extra_tb,10,4,4,-1,16, $Behind_split );
	    ### END ###
	    ELSE
	      ### Check if race is ON and gaps is ON ###
	      IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" && ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == "on" ) )
	      THEN
	        IF ($split == 1)
	        THEN
		  SetCurrentPlayerVar( "Behind_gap_1", GetCurrentPlayerVar( "GapBehind" ) );
	          IF ( GetCurrentPlayerVar( "Behind_gap_last" ) != "")
		  THEN
		    IF ( GetCurrentPlayerVar( "Behind_gap_1" ) >= GetCurrentPlayerVar( "Behind_gap_last" ) )
		    THEN
		      openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_1" ) );
		    ELSE
		      openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_1" ) );
		    ENDIF
		  ELSE
		    openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . GetCurrentPlayerVar( "Behind_gap_1" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 2)
	        THEN
		  SetCurrentPlayerVar( "Behind_gap_2", GetCurrentPlayerVar( "GapBehind" ) );
		  IF ( GetCurrentPlayerVar( "Behind_gap_2" ) >= GetCurrentPlayerVar( "Behind_gap_1" ))
		  THEN
		    openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_2" ) );
		  ELSE
		    openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_2" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 3)
	        THEN
		  SetCurrentPlayerVar( "Behind_gap_3", GetCurrentPlayerVar( "GapBehind" ) );
		  IF ( GetCurrentPlayerVar( "Behind_gap_3" ) >= GetCurrentPlayerVar( "Behind_gap_2" ) )
		  THEN
		    openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_3" ) );
		  ELSE
		    openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_3" ) );
		  ENDIF
	        ENDIF

	        IF ($split == 4)
	        THEN
		  SetCurrentPlayerVar( "Behind_gap_last", GetCurrentPlayerVar( "GapBehind" ) );
		  IF ( $splits_value == 4 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_3" ) )
		    THEN
		      $Color_gap_behind="^2";
		    ELSE
		      $Color_gap_behind="^1";
		    ENDIF
		  ENDIF

		  IF ( $splits_value == 3 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_2" ) )
		    THEN
		      $Color_gap_behind="^2";
		    ELSE
		      $Color_gap_behind="^1";
		    ENDIF
		  ENDIF

		  IF ( $splits_value == 2 )
		  THEN
		    IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_1" ) )
		    THEN
		      $Color_gap_behind="^2";
		    ELSE
		      $Color_gap_behind="^1";
		    ENDIF
		  ENDIF

		  openPrivButton( "pitboard_behind_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_gap_behind . GetCurrentPlayerVar( "Behind_gap_last" ) );
	        ENDIF
	      ENDIF
	    ENDIF
	    ### END ####
	  ELSE
	    ### Check if race is ON ###
	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" )
	    THEN
	      IF ($split == 1)
	      THEN
	        openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 2)
	      THEN
	        openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 3)
	      THEN
	        openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"" );
	      ENDIF

	      IF ($split == 4)
	      THEN
	        openPrivButton( "pitboard_behind_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"" );
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
EndSub

Sub OnSpbSplit1_Pitboard() # Player event
	### Get value Penalty_laps ###
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	### End ##

	### Set colors when current S1 is best S1 or within set limit of best S1 ###
	IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 1)
	THEN
	  $Color_split1 = "^2";
	  SetCurrentPlayerVar("Lastsplit1_color","^1" );
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    IF ( GetCurrentPlayerVar("Information_2") == "")
	    THEN
	      SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit1" )) );
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 0)
	  THEN
	    IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplit1")+GetCurrentPlayerVar ("split_setting")) )
	    THEN
	      $Color_split1 = "^3";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
		ENDIF
	      ENDIF
	    ELSE
	      $Color_split1 = "^1";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit1" )) );
		ENDIF
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	### Do actions in first lap of qualify/race ###
	IF ( GetCurrentPlayerVar( "LapsDone" ) == 0)
	THEN
	  ### Clear values of last practice/qualify/race ###
	  SetCurrentPlayerVar("Lastsplit1","");
	  SetCurrentPlayerVar("Lastsplit2","");
	  SetCurrentPlayerVar("Lastsplit3","");
	  SetCurrentPlayerVar("Lastsplitlast","");
	  SetCurrentPlayerVar("Information","");
	  SetCurrentPlayerVar("Information_2","");
	  ### End ###

	  ### Set penalty check and laps to orginal value ###
	  SetCurrentPlayerVar( "Penalty_check","false");
	  SetCurrentPlayerVar( "Penalty_laps",$penalty_laps);
	  ### End ###

	  ### Close buttons for sector 2,3,last and information ###
	  closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	  closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	  closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2&pitboard_before_sector_3&pitboard_behind_sector_3&pitboard_before_sector_last&pitboard_behind_sector_last" );
	  closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	  closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	  closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	  closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	  closePrivButton( "pitboard_information&pitboard_information_2" ); 
	  ### End ###

	  ### Display Pitlane status in case Pitlane is opened from lap 1 ####
	  IF ( GetCurrentPlayerVar("Information") == "" )
	  THEN
	    IF ( $qualify == "off" && GetCurrentPlayerVar( "LapsDone" ) == $start_window_1-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_2-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_3-1 )
	    THEN
	      SetCurrentPlayerVar("Information","^2Pitlane open^8");
	    ELSE
	      IF ( $qualify == "off" && GetCurrentPlayerVar( "LapsDone" ) == $end_window_1 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_2 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_3 )
	      THEN
	        SetCurrentPlayerVar("Information","^1Pitlane closed^8");
	      ENDIF
	    ENDIF
	  ENDIF
	  ### End ###
	ENDIF
	### End ###

	### Set Information when it's empty and when spb_setting is set to "splits" ###
	IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
	THEN
	  IF ( GetCurrentPlayerVar("Information") == "" )
	  THEN
	    IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 1 )
	    THEN
	      SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical") == "on" )
	THEN
	  /*
	  ### Display:  Nickname, Start PW, End PW, Stops and their values ###
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,$pitboard_hight+4,5,-1,32,"");
	  ELSE
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,$pitboard_hight,5,-1,32,"");
	  ENDIF
	  openPrivButton( "pitboard_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+1,30,4,4,-1,0,"^7Pitboard:^0 " . GetCurrentPlayerVar( "Nickname" ) );
	  
	  openPrivButton( "pitboard_start_pitwindow",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^2Start PW:");
	  openPrivButton( "pitboard_end_pitwindow",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^1End PW:");
	  openPrivButton( "pitboard_pw_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+5,10,4,4,-1,16,"^7Stops: ");
	  */

	  IF ($number_of_windows != "" && $qualify == "off")
	  THEN
	    FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  closePrivButton( "pitboard_no_pitwindow");

		  IF ($number_of_windows == 1 && $qualify == "off")
		  THEN
		    openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		    openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		    openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		  ENDIF

		  IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		  THEN
		    openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		    openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		    openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		  ELSE
		    IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		    ENDIF
		  ENDIF

		  IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		  THEN
		    openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		    openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		    openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		  ELSE
		    IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		    ELSE
		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		      THEN
		        openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_3);
		        openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_3);
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
		      ENDIF
		    ENDIF
		  ENDIF
		ENDIF
	    ENDFOR
	  ELSE
	    IF ($number_of_windows == "" || $qualify == "on")
	    THEN
	      closePrivButton( "pitboard_start_pitwindow_lap&pitboard_end_pitwindow_lap&pitboard_number_of_stops" );
	      openPrivButton( "pitboard_no_pitwindow",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,30,4,4,-1,16,"^7No pitwindow");
	    ENDIF
	  ENDIF	  
	  ### END ###

	  IF ($safetycar_status == "out" || $safetycar_status == "in" )
	  THEN
	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,28,4,-1,16,"" );
	    openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
	    openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
	    openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
	  ELSE
	    ### Display values Curr S1, Last S1, Best S1 ###
	    closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "off" )
	    THEN
	      openPrivButton( "pitboard_current_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Curr S1:");
	      openPrivButton( "pitboard_last_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Last S1:");
	      openPrivButton( "pitboard_best_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Best S1:");

	      IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 1)
	      THEN
	        openPrivButton( "pitboard_best_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
	      ELSE
	        openPrivButton( "pitboard_best_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit1" )) );
	      ENDIF
	  
	      openPrivButton( "pitboard_current_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,$Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
	      openPrivButton( "pitboard_last_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) );
	    ELSE
	      openPrivButton( "pitboard_current_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Fr S1:");
	      openPrivButton( "pitboard_last_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Own S1:");
	      openPrivButton( "pitboard_best_sector_1_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,10,4,4,-1,16,"^7Bh S1:");

	      openPrivButton( "pitboard_current_sector_1",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+17,10,4,4,-1,16,$Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
	    ENDIF
	    ### End ###

	    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
	    SetCurrentPlayerVar("Information","");
	    
	    IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	    THEN
	      openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" )
	  THEN
	    ### Text mode messages when Safetycar is on track ###
	    IF ($safetycar_status == "out" || $safetycar_status == "in" )
	    THEN
	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . $safetycar_message_1 );
	      PrivMsg ("^7INF: " . $safetycar_message_2 );
	      PrivMsg ("^7INF: " . $safetycar_message_3 );
	      ### End ###
	    ELSE
	      ### Text-mode when people choose not to use the Pitboard ###
	      IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 1)
	      THEN
	        PrivMsg ("^7CS1: " . $Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) . " ^7| LS1: " . GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) . " ^7| BS1: " . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );  
	      ELSE
	        PrivMsg ("^7CS1: " . $Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) . " ^7| LS1: " . GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) . " ^7| BS1: " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit1" )) );
	      ENDIF

	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	      IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
	      THEN
	        SetCurrentPlayerVar("Information","");
	      ENDIF
	      ### End ###
	    ENDIF
	  ENDIF
	ENDIF

	### Store value last SectorSplit1 ###
	SetCurrentPlayerVar("Lastsplit1_color",$Color_split1 );
	SetCurrentPlayerVar("Lastsplit1", NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
	### End ###

EndSub

Sub OnSpbSplit2_Pitboard() # Player event
	### Get value Penalty_laps ###
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	### End ##

	### Set colors when current S2 is best S2 or within set limit of best S2 ###
	IF ( GetCurrentPlayerVar("isBestSectorSplit2") == 1)
	THEN
	  $Color_split2 = "^2";
	  SetCurrentPlayerVar("Lastsplit2_color","^1" );
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    IF ( GetCurrentPlayerVar("Information_2") == "")
	    THEN
	      SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit2" )) );
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar("isBestSectorSplit2") == 0)
	  THEN
	    IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplit2")+GetCurrentPlayerVar ("split_setting")) )
	    THEN
	      $Color_split2 = "^3";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
		ENDIF
	      ENDIF
	    ELSE
	      $Color_split2 = "^1";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit2" )) );
		ENDIF
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	### Set Information when it's empty and when spb_setting is set to "splits" ###
	IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
	THEN
	  IF ( GetCurrentPlayerVar("Information") == "" )
	  THEN
	    IF ( GetCurrentPlayerVar("isBestSectorSplit2") == 1 )
	    THEN
	      SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	THEN
	  IF ($safetycar_status == "out" || $safetycar_status == "in" )
	  THEN
	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,28,4,-1,16,"" );
	    openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
	    openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
	    openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
	  ELSE
	    ### Display Curr S2, Last S2, Best S2 and their values ###
	    closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "off" )
	    THEN
	      openPrivButton( "pitboard_current_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Curr S2:");
	      openPrivButton( "pitboard_last_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Last S2:");
	      openPrivButton( "pitboard_best_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Best S2:");

	      IF ( GetCurrentPlayerVar("isBestSectorSplit2") == 1)
	      THEN
	        openPrivButton( "pitboard_best_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) );
	      ELSE
	        openPrivButton( "pitboard_best_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit2" )) );
	      ENDIF

	      openPrivButton( "pitboard_current_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,$Color_split2 . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) );
	      openPrivButton( "pitboard_last_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplit2_color" ) . GetCurrentPlayerVar( "Lastsplit2" ) );
	    ELSE
	      openPrivButton( "pitboard_current_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Fr S2:");
	      openPrivButton( "pitboard_last_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Own S2:");
	      openPrivButton( "pitboard_best_sector_2_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+21,10,4,4,-1,16,"^7Bh S2:");

	      openPrivButton( "pitboard_current_sector_2",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+25,10,4,4,-1,16,$Color_split2 . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) );
	    ENDIF
	    ### End ###

	    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
	    SetCurrentPlayerVar("Information","");

	    IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	    THEN
	      openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" )
	  THEN
	    ### Text mode messages when Safetycar is on track ###
	    IF ($safetycar_status == "out" || $safetycar_status == "in" )
	    THEN
	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . $safetycar_message_1 );
	      PrivMsg ("^7INF: " . $safetycar_message_2 );
	      PrivMsg ("^7INF: " . $safetycar_message_3 );
	      ### End ###
	    ELSE
	      ### Text-mode when people choose not to use the Pitboard ###
	      IF ( GetCurrentPlayerVar("isBestSectorSplit2") == 1)
	      THEN
	        PrivMsg ("^7CS2: " . $Color_split2 . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) . " ^7| LS2: " . GetCurrentPlayerVar( "Lastsplit2_color" ) . GetCurrentPlayerVar( "Lastsplit2" ) . " ^7| BS2: " . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) );  
	      ELSE
	        PrivMsg ("^7CS2: " . $Color_split2 . NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) . " ^7| LS2: " . GetCurrentPlayerVar( "Lastsplit2_color" ) . GetCurrentPlayerVar( "Lastsplit2" ) . " ^7| BS2: " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit2" )) );
	      ENDIF

	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	      IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
	      THEN
	        SetCurrentPlayerVar("Information","");
	      ENDIF
	      ### End ###
	    ENDIF
	  ENDIF
	ENDIF

	### Store value last SectorSplit2 ###
	SetCurrentPlayerVar("Lastsplit2_color",$Color_split2 );
	SetCurrentPlayerVar("Lastsplit2", NumToMSH(GetCurrentPlayerVar( "SectorSplit2" )) );
	### End ###

EndSub

Sub OnSpbSplit3_Pitboard() # Player event
	### Get value Penalty_laps ###
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	### End ##

	### Set colors when current S3 is best S3 or within set limit of best S3 ###
	IF ( GetCurrentPlayerVar("isBestSectorSplit3") == 1)
	THEN
	  $Color_split3 = "^2";
	  SetCurrentPlayerVar("Lastsplit3_color","^1" );
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    IF ( GetCurrentPlayerVar("Information_2") == "")
	    THEN
	      SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit3" )) );
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar("isBestSectorSplit3") == 0)
	  THEN
	    IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplit3")+GetCurrentPlayerVar ("split_setting")) )
	    THEN
	      $Color_split3 = "^3";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
		ENDIF
	      ENDIF
	    ELSE
	      $Color_split3 = "^1";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit3" )) );
		ENDIF
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	### Set Information when it's empty and when spb_setting is set to "splits" ####
	IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
	THEN
	  IF ( GetCurrentPlayerVar("Information") == "" )
	  THEN
	    IF ( GetCurrentPlayerVar("isBestSectorSplit3") == 1 )
	    THEN
	      SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	THEN
	  IF ($safetycar_status == "out" || $safetycar_status == "in" )
	  THEN
	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,28,4,-1,16,"" );
	    openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
	    openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
	    openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
	  ELSE
	    ### Display Curr S3, Last S3, Best S3 and their values ###
	    closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "off" )
	    THEN
	      openPrivButton( "pitboard_current_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Curr S3:");
	      openPrivButton( "pitboard_last_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Last S3:");
	      openPrivButton( "pitboard_best_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Best S3:");

	      IF ( GetCurrentPlayerVar("isBestSectorSplit3") == 1)
	      THEN
	        openPrivButton( "pitboard_best_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) );
	      ELSE
	        openPrivButton( "pitboard_best_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit3" )) );
	      ENDIF

	      openPrivButton( "pitboard_current_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,$Color_split3 . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) );
	      openPrivButton( "pitboard_last_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplit3_color" ) . GetCurrentPlayerVar( "Lastsplit3" ) );
	    ELSE
	      openPrivButton( "pitboard_current_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Fr S3:");
	      openPrivButton( "pitboard_last_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Own S3:");
	      openPrivButton( "pitboard_best_sector_3_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+29,10,4,4,-1,16,"^7Bh S3:");

	      openPrivButton( "pitboard_current_sector_3",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+33,10,4,4,-1,16,$Color_split3 . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) );
	    ENDIF
	    ### End ###

	    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
	    SetCurrentPlayerVar("Information","");

	    IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	    THEN
	      openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" )
	  THEN
	    ### Text mode messages when Safetycar is on track ###
	    IF ($safetycar_status == "out" || $safetycar_status == "in" )
	    THEN
	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . $safetycar_message_1 );
	      PrivMsg ("^7INF: " . $safetycar_message_2 );
	      PrivMsg ("^7INF: " . $safetycar_message_3 );
	      ### End ###
	    ELSE
	      ### Text-mode when people choose not to use the Pitboard ###
	      IF ( GetCurrentPlayerVar("isBestSectorSplit3") == 1)
	      THEN
	        PrivMsg ("^7CS3: " . $Color_split3 . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) . " ^7| LS3: " . GetCurrentPlayerVar( "Lastsplit3_color" ) . GetCurrentPlayerVar( "Lastsplit3" ) . " ^7| BS3: " . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) );  
	      ELSE
	        PrivMsg ("^7CS3: " . $Color_split3 . NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) . " ^7| LS3: " . GetCurrentPlayerVar( "Lastsplit3_color" ) . GetCurrentPlayerVar( "Lastsplit3" ) . " ^7| BS3: " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit3" )) );
	      ENDIF

	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	      IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
	      THEN
	        SetCurrentPlayerVar("Information","");
	      ENDIF
	      ### End ###
	    ENDIF
	  ENDIF
	ENDIF

	### Store value last SectorSplit3 ###
	SetCurrentPlayerVar("Lastsplit3_color",$Color_split3 );
	SetCurrentPlayerVar("Lastsplit3", NumToMSH(GetCurrentPlayerVar( "SectorSplit3" )) );
	### End ###

EndSub

Sub OnSpbLast_Pitboard() # Player event

	$Penalty_check = GetCurrentPlayerVar("Penalty_check");
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	$Lapsdone = GetCurrentPlayerVar( "LapsDone" )+0; ### extra code to convert LapsDone to numerical value ###

	### Check if Pitstop is done before the end of Pitwindow 1,2,3 ###
	### If not, set Penalty_check to true ###
	### If Penalty_check is true, reduce Penalty_laps by one ###
	### If Penalty_laps is zero, spectate player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ($number_of_windows == 1 && $qualify == "off")
		  THEN
		    IF ($end_window_3 != "" && $Lapsdone >= $end_window_3)
		    THEN
		      IF ($user_array[$i,4] != 0)
		      THEN
		        IF ($Penalty_check == "false")
		        THEN
		          cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			  $Penalty_check="true_window_3";
			  SetCurrentPlayerVar("Penalty_check",$Penalty_check);
		        ELSE
		          $Player_penalty_laps=$Player_penalty_laps-1;
			  SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			  IF ($Player_penalty_laps == 0)
			  THEN
			    cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			  ENDIF
		        ENDIF
		      ENDIF
		    ELSE
		      IF ($end_window_2 != "" && $Lapsdone >= $end_window_2)
		      THEN
		        IF ($user_array[$i,3] != 0)
		        THEN
		          IF ($Penalty_check == "false")
			  THEN
			    cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			    $Penalty_check="true_window_2";
			    SetCurrentPlayerVar("Penalty_check",$Penalty_check);
			  ELSE
			    $Player_penalty_laps=$Player_penalty_laps-1;
			    SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			    IF ($Player_penalty_laps == 0)
			    THEN
			      cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			    ENDIF
			  ENDIF
		        ENDIF
		      ELSE
		        IF ($end_window_1 != "" && $Lapsdone >= $end_window_1)
		        THEN
		          IF ($user_array[$i,2] != 0)
			  THEN
			    IF ($Penalty_check == "false")
			    THEN
			      cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			      $Penalty_check="true_window_1";
			      SetCurrentPlayerVar("Penalty_check",$Penalty_check);
			    ELSE
			      $Player_penalty_laps=$Player_penalty_laps-1;
			      SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			      IF ($Player_penalty_laps == 0)
			      THEN
			        cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			      ENDIF
			    ENDIF
			  ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		  THEN
		    IF ($number_of_windows == 1 && $qualify == "off")
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ENDIF

		    IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ELSE
		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		      THEN
		        openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		        openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ENDIF
		    ENDIF

		    IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ELSE
		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		      THEN
		        openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		        openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		        THEN
		          openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_3);
		          openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_3);
		          openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
		        ENDIF
		      ENDIF
		    ENDIF
		  ENDIF

		  ### Set information about Black flag or Pitlane status and display information button ###
		  IF ($Penalty_check == "true_window_1" || $Penalty_check == "true_window_2" || $Penalty_check == "true_window_3")
		  THEN
		    SetCurrentPlayerVar("Information"," ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! ");
		  ENDIF

		  IF ( GetCurrentPlayerVar("Information") == "" )
		  THEN
		    IF ( $qualify == "off" && GetCurrentPlayerVar( "LapsDone" ) == $start_window_1-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_2-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_3-1 )
		    THEN
		      SetCurrentPlayerVar("Information","^2Pitlane open^8");
		    ELSE
		      IF ( $qualify == "off" && GetCurrentPlayerVar( "LapsDone" ) == $end_window_1 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_2 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_3 )
		      THEN
		        SetCurrentPlayerVar("Information","^1Pitlane closed^8");
		      ENDIF
		    ENDIF
		  ENDIF
		    
		  IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
		  THEN
		    IF ( GetCurrentPlayerVar("Information") == "" )
		    THEN
		      IF ( GetCurrentPlayerVar("isBestSectorSplitLast") == 1 )
		      THEN
		        SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
		      ENDIF
		    ENDIF
		  ELSE
		    IF ( GetCurrentPlayerVar("Information") == "" )
		    THEN
		      IF ( GetCurrentPlayerVar("isBestSectorSplit1") == 1 || GetCurrentPlayerVar("isBestSectorSplit2") == 1	|| GetCurrentPlayerVar("isBestSectorSplit3") == 1 || GetCurrentPlayerVar("isBestSectorSplitLast") == 1 )
		      THEN
		        SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
		      ENDIF
		    ENDIF
		  ENDIF
		  ### End ###

		  IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		  THEN
		    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
		    IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
		    THEN
		      SetCurrentPlayerVar("Information","");
		    ENDIF
		  ENDIF
	        ENDIF
	ENDFOR
	### End ###

	### Set colors when current S1 is best S1 or within set limit of best S1 ###
	IF ( GetCurrentPlayerVar("isBestSectorSplitLast") == 1)
	THEN
	  $Color_splitlast = "^2";
	  SetCurrentPlayerVar("Lastsplitlast_color","^1" );
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	  THEN
	    IF ( GetCurrentPlayerVar("Information_2") == "")
	    THEN
	      SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplitLast" )) );
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar("isBestSectorSplitLast") == 0)
	  THEN
	    IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplitLast")+GetCurrentPlayerVar ("split_setting")) )
	    THEN
	      $Color_splitlast = "^3";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
		ENDIF
	      ENDIF
	    ELSE
	      $Color_splitlast = "^1";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplitLast" )) );
		ENDIF
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	THEN
	  IF ($safetycar_status == "out" || $safetycar_status == "in" )
	  THEN
	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,28,4,-1,16,"" );
	    openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
	    openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
	    openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
	  ELSE
	    ### Display Curr last, Last last, Best last and their values ###
	    closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == "off" )
	    THEN
	      openPrivButton( "pitboard_current_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Curr S" . $splits_value . ":" );
	      openPrivButton( "pitboard_last_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Last S" . $splits_value . ":");
	      openPrivButton( "pitboard_best_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Best S" . $splits_value . ":");

	      IF ( GetCurrentPlayerVar("isBestSectorSplitLast") == 1)
	      THEN
	        openPrivButton( "pitboard_best_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	      ELSE
	        openPrivButton( "pitboard_best_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplitLast" )) );
	      ENDIF

	      openPrivButton( "pitboard_current_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	      openPrivButton( "pitboard_last_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) );
	    ELSE
	      openPrivButton( "pitboard_current_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Fr S" . $splits_value . ":" );
	      openPrivButton( "pitboard_last_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Own S" . $splits_value . ":");
	      openPrivButton( "pitboard_best_sector_last_txt",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Bh S" . $splits_value . ":");

	      openPrivButton( "pitboard_current_sector_last",GetCurrentPlayerVar ( "left_right_coordinate")+11,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	    ENDIF
	    ### End ###

	    IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == "yes")
	    THEN
	      openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" )
	  THEN
	    ### Text mode messages when Safetycar is on track ###
	    IF ($safetycar_status == "out" || $safetycar_status == "in" )
	    THEN
	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . $safetycar_message_1 );
	      PrivMsg ("^7INF: " . $safetycar_message_2 );
	      PrivMsg ("^7INF: " . $safetycar_message_3 );
	      ### End ###
	    ELSE
	      ### Text-mode when people choose not to use the Pitboard ###
	      IF ( GetCurrentPlayerVar("isBestSectorSplitLast") == 1)
	      THEN
	        PrivMsg ("^7CS" . $splits_value . ": " . $Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) . " ^7| LS" . $splits_value . ": " . GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) . " ^7| BS" . $splits_value . ": " . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );  
	      ELSE
	        PrivMsg ("^7CS" . $splits_value . ": " . $Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) . " ^7| LS" . $splits_value . ": " . GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) . " ^7| BS" . $splits_value . ": " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplitLast" )) );
	      ENDIF

	      IF ($number_of_windows != "" && $qualify == "off")
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == "off")
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == "off")
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == "on")
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	      IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
	      THEN
	        SetCurrentPlayerVar("Information","");
	      ENDIF
	      ### End ###
	    ENDIF
	  ENDIF
	ENDIF

	### Store value last SectorSplitLast ###
	SetCurrentPlayerVar("Lastsplitlast_color",$Color_splitlast );
	SetCurrentPlayerVar("Lastsplitlast", NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	### End ###

EndSub

Sub Config_Pitboard( $KeyFlags )
	$tb_coordinate=50;
	$lr_coordinate=75;
	openPrivButton( "config_pb_bg",$lr_coordinate,$tb_coordinate,50,92,5,-1,16,"" );
	openPrivButton( "config_pb_title",$lr_coordinate+1,$tb_coordinate+1,48,5,5,-1,0,"^7Configure Pitboard V2.04f settings" );

	### Selection display mode ###
	openPrivButton( "config_pb_display_mode_txt",$lr_coordinate+1,$tb_coordinate+6,48,5,5,-1,32,"^7Display mode" );
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	THEN
	  openPrivButton( "config_pb_display_mode_graphical",$lr_coordinate+1,$tb_coordinate+11,16,5,5,-1,32,"^2Graphical" );
	  openPrivButton( "config_pb_display_mode_text",$lr_coordinate+17,$tb_coordinate+11,16,5,5,-1,32,"^3Text", config_pb_display_mode_text );
	  openPrivButton( "config_pb_display_mode_off",$lr_coordinate+33,$tb_coordinate+11,16,5,5,-1,32,"^3Off", config_pb_display_mode_off );

	  ### Selection information mode ###
	  openPrivButton( "config_pb_information_mode_txt",$lr_coordinate+1,$tb_coordinate+16,48,5,5,-1,32,"^7Information mode" );
	  IF ( GetCurrentPlayerVar( "config_pb_practise" ) == "on" )
	  THEN
	    openPrivButton( "config_pb_practise",$lr_coordinate+1,$tb_coordinate+21,24,5,5,-1,32,"^2Practise", config_pb_practise );
	  ELSE
	    openPrivButton( "config_pb_practise",$lr_coordinate+1,$tb_coordinate+21,24,5,5,-1,32,"^3Practise", config_pb_practise );
	  ENDIF
	  
	  IF ( GetCurrentPlayerVar( "config_pb_race" ) == "on" )
	  THEN
	    openPrivButton( "config_pb_race",$lr_coordinate+25,$tb_coordinate+21,24,5,5,-1,32,"^2Race", config_pb_race );
	    IF ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == "on" )
	    THEN
	      openPrivButton( "config_pb_race_gaps",$lr_coordinate+25,$tb_coordinate+26,24,5,5,-1,32,"^2Gaps", config_pb_race_gaps );
	    ELSE
	      openPrivButton( "config_pb_race_gaps",$lr_coordinate+25,$tb_coordinate+26,24,5,5,-1,32,"^3Gaps", config_pb_race_gaps );
	    ENDIF
	  
	    IF ( GetCurrentPlayerVar( "config_pb_race_splits" ) == "on" )
	    THEN
	      openPrivButton( "config_pb_race_splits",$lr_coordinate+25,$tb_coordinate+31,24,5,5,-1,32,"^2Splits", config_pb_race_splits );
	    ELSE
	      openPrivButton( "config_pb_race_splits",$lr_coordinate+25,$tb_coordinate+31,24,5,5,-1,32,"^3Splits", config_pb_race_splits );
	    ENDIF
	  ELSE
	    openPrivButton( "config_pb_race",$lr_coordinate+25,$tb_coordinate+21,24,5,5,-1,32,"^3Race", config_pb_race );
	  ENDIF
	  ### End ###

	  ### Set left/right and top/bottom coordinates ###
	  openPrivButton( "config_pb_tb_coordinate",$lr_coordinate+1,$tb_coordinate+36,24,5,5,-1,32,"^7Top/Bottom coordinate" );
	  openPrivButton( "config_pb_tb_coordinate_min",$lr_coordinate+1,$tb_coordinate+41,7,5,5,-1,32,"^3-", config_pb_tb_coordinate_min );
	  openPrivButton( "config_pb_tb_coordinate_value",$lr_coordinate+8,$tb_coordinate+41,10,5,5,-1,32,"^7" . GetCurrentPlayerVar ( "top_bottom_coordinate") );
	  openPrivButton( "config_pb_tb_coordinate_plus",$lr_coordinate+18,$tb_coordinate+41,7,5,5,-1,32,"^3+", config_pb_tb_coordinate_plus );

	  openPrivButton( "config_pb_lr_coordinate",$lr_coordinate+25,$tb_coordinate+36,24,5,5,-1,32,"^7Left/Right coordinate" );
	  openPrivButton( "config_pb_lr_coordinate_min",$lr_coordinate+25,$tb_coordinate+41,7,5,5,-1,32,"^3-", config_pb_lr_coordinate_min );
	  openPrivButton( "config_pb_lr_coordinate_value",$lr_coordinate+32,$tb_coordinate+41,10,5,5,-1,32,"^7" . GetCurrentPlayerVar ( "left_right_coordinate") );
	  openPrivButton( "config_pb_lr_coordinate_plus",$lr_coordinate+42,$tb_coordinate+41,7,5,5,-1,32,"^3+", config_pb_lr_coordinate_plus );	  	  
	  ### End ###

	  ### Test Pitboard position ###
	  openPrivButton( "config_pb_test_position",$lr_coordinate+1,$tb_coordinate+46,24,5,5,-1,32,"^3Test position", config_pb_test_position );
	  openPrivButton( "config_pb_test_end",$lr_coordinate+25,$tb_coordinate+46,24,5,5,-1,32,"^3End test", config_pb_test_end );
	  ### End ###

	  ### Set value (in milliseconds) when split has to be shown in yellow. ###
	  openPrivButton( "config_pb_split_setting_txt",$lr_coordinate+1,$tb_coordinate+51,48,5,5,-1,32,"^7Yellow split setting (ms)" );
   	  IF ( GetCurrentPlayerVar ("split_setting") == "")
	  THEN
	    openPrivTextButton( "config_pb_split_setting_value",$lr_coordinate+1,$tb_coordinate+56,48,5,5,32,"^3Time in milliseconds","^3Time in ms",5,config_pb_split_setting_value );
	  ELSE
	    openPrivTextButton( "config_pb_split_setting_value",$lr_coordinate+1,$tb_coordinate+56,48,5,5,32,"^3Time in milliseconds","^3".GetCurrentPlayerVar ("split_setting"),5,config_pb_split_setting_value );
	  ENDIF
	  ### End ###

	  ### Set when to show SPB messages ###
	  openPrivButton( "config_pb_spb_setting_txt",$lr_coordinate+1,$tb_coordinate+61,48,5,5,-1,32,"^7When to show SPB messages" );
	  IF ( GetCurrentPlayerVar ("spb_setting") == "end")
	  THEN
	    openPrivButton( "config_pb_spb_setting_endlap",$lr_coordinate+1,$tb_coordinate+66,24,5,5,-1,32,"^2End of lap" );
	    openPrivButton( "config_pb_spb_setting_splits",$lr_coordinate+25,$tb_coordinate+66,24,5,5,-1,32,"^3All splits",config_pb_spb_setting );
	  ELSE
	    openPrivButton( "config_pb_spb_setting_endlap",$lr_coordinate+1,$tb_coordinate+66,24,5,5,-1,32,"^3End of lap",config_pb_spb_setting );
	    openPrivButton( "config_pb_spb_setting_splits",$lr_coordinate+25,$tb_coordinate+66,24,5,5,-1,32,"^2All splits" );
	  ENDIF
	  ### End ###

	  ### Set option to wether lost/gained messages have to be shown ###
	  openPrivButton( "config_pb_lost/gained_txt",$lr_coordinate+1,$tb_coordinate+71,48,5,5,-1,32,"^7show lost/gained messages" );
	  IF ( GetCurrentPlayerVar ("lost_gained_messages") == "yes")
	  THEN
	    openPrivButton( "config_pb_lost/gained_yes",$lr_coordinate+1,$tb_coordinate+76,24,5,5,-1,32,"^2Yes" );
	    openPrivButton( "config_pb_lost/gained_no",$lr_coordinate+25,$tb_coordinate+76,24,5,5,-1,32,"^3No", config_pb_lost_gained_setting );
	  ELSE
	    openPrivButton( "config_pb_lost/gained_yes",$lr_coordinate+1,$tb_coordinate+76,24,5,5,-1,32,"^3Yes", config_pb_lost_gained_setting );
	    openPrivButton( "config_pb_lost/gained_no",$lr_coordinate+25,$tb_coordinate+76,24,5,5,-1,32,"^2No" );
	  ENDIF
	  ### End ###
	ENDIF
	
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" )
	THEN
	  openPrivButton( "config_pb_display_mode_graphical",$lr_coordinate+1,$tb_coordinate+11,16,5,5,-1,32,"^3Graphical", config_pb_display_mode_graphical );
	  openPrivButton( "config_pb_display_mode_text",$lr_coordinate+17,$tb_coordinate+11,16,5,5,-1,32,"^2Text" );
	  openPrivButton( "config_pb_display_mode_off",$lr_coordinate+33,$tb_coordinate+11,16,5,5,-1,32,"^3Off", config_pb_display_mode_off );

	  ### Information mode ###
	  openPrivButton( "config_pb_information_mode_txt",$lr_coordinate+1,$tb_coordinate+16,48,5,5,-1,32,"^7Information mode" );
	  openPrivButton( "config_pb_practise",$lr_coordinate+1,$tb_coordinate+21,24,5,5,-1,32,"^2Practise", config_pb_practise );
	  ### End ###

	  ### Set left/right and top/bottom coordinates ###
	  openPrivButton( "config_pb_tb_coordinate",$lr_coordinate+1,$tb_coordinate+36,24,5,5,-1,32,"^7Top/Bottom coordinate" );
	  openPrivButton( "config_pb_lr_coordinate",$lr_coordinate+25,$tb_coordinate+36,24,5,5,-1,32,"^7Left/Right coordinate" );
	  ### End ###

	  ### Set value (in milliseconds) when split has to be shown in yellow. ###
	  openPrivButton( "config_pb_split_setting_txt",$lr_coordinate+1,$tb_coordinate+51,48,5,5,-1,32,"^7Yellow split setting (ms)" );
   	  IF ( GetCurrentPlayerVar ("split_setting") == "")
	  THEN
	    openPrivTextButton( "config_pb_split_setting_value",$lr_coordinate+1,$tb_coordinate+56,48,5,5,32,"^3Time in milliseconds","^3Time in ms",5,config_pb_split_setting_value );
	  ELSE
	    openPrivTextButton( "config_pb_split_setting_value",$lr_coordinate+1,$tb_coordinate+56,48,5,5,32,"^3Time in milliseconds","^3".GetCurrentPlayerVar ("split_setting"),5,config_pb_split_setting_value );
	  ENDIF
	  ### End ###

	  ### Set when to show SPB messages ###
	  openPrivButton( "config_pb_spb_setting_txt",$lr_coordinate+1,$tb_coordinate+61,48,5,5,-1,32,"^7When to show SPB messages" );
	  IF ( GetCurrentPlayerVar ("spb_setting") == "end")
	  THEN
	    openPrivButton( "config_pb_spb_setting_endlap",$lr_coordinate+1,$tb_coordinate+66,24,5,5,-1,32,"^2End of lap" );
	    openPrivButton( "config_pb_spb_setting_splits",$lr_coordinate+25,$tb_coordinate+66,24,5,5,-1,32,"^3All splits",config_pb_spb_setting );
	  ELSE
	    openPrivButton( "config_pb_spb_setting_endlap",$lr_coordinate+1,$tb_coordinate+66,24,5,5,-1,32,"^3End of lap",config_pb_spb_setting );
	    openPrivButton( "config_pb_spb_setting_splits",$lr_coordinate+25,$tb_coordinate+66,24,5,5,-1,32,"^2All splits" );
	  ENDIF
	  ### End ###

	  ### Set option to wether lost/gained messages have to be shown ###
	  openPrivButton( "config_pb_lost/gained_txt",$lr_coordinate+1,$tb_coordinate+71,48,5,5,-1,32,"^7show lost/gained messages" );
	  IF ( GetCurrentPlayerVar( "config_pb_practise" ) == "on" )
	  THEN
	    IF ( GetCurrentPlayerVar ("lost_gained_messages") == "yes")
	    THEN
	      openPrivButton( "config_pb_lost/gained_yes",$lr_coordinate+1,$tb_coordinate+76,24,5,5,-1,32,"^2Yes" );
	      openPrivButton( "config_pb_lost/gained_no",$lr_coordinate+25,$tb_coordinate+76,24,5,5,-1,32,"^3No", config_pb_lost_gained_setting );
	    ELSE
	      openPrivButton( "config_pb_lost/gained_yes",$lr_coordinate+1,$tb_coordinate+76,24,5,5,-1,32,"^3Yes", config_pb_lost_gained_setting );
	      openPrivButton( "config_pb_lost/gained_no",$lr_coordinate+25,$tb_coordinate+76,24,5,5,-1,32,"^2No" );
	    ENDIF
	  ENDIF
	  ### End ###
	ENDIF
	
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_off" ) == "on" )
	THEN
	  openPrivButton( "config_pb_display_mode_graphical",$lr_coordinate+1,$tb_coordinate+11,16,5,5,-1,32,"^3Graphical", config_pb_display_mode_graphical );
	  openPrivButton( "config_pb_display_mode_text",$lr_coordinate+17,$tb_coordinate+11,16,5,5,-1,32,"^3Text", config_pb_display_mode_text );
	  openPrivButton( "config_pb_display_mode_off",$lr_coordinate+33,$tb_coordinate+11,16,5,5,-1,32,"^2Off" );
	ENDIF
	### End ###

	### Save and Close button ###
	openPrivButton( "config_pb_save_settings",$lr_coordinate+1,$tb_coordinate+86,24,5,5,-1,32,"^3Save settings", config_pb_save_settings );
	openPrivButton( "config_pb_close",$lr_coordinate+25,$tb_coordinate+86,24,5,5,-1,32,"^3CLOSE", config_pb_close );
	### End ###
EndSub

Sub config_pb_display_mode_graphical ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode_graphical","on" );
	SetCurrentPlayerVar( "config_pb_display_mode_text","off" );
	SetCurrentPlayerVar( "config_pb_display_mode_off","off" );
	SetCurrentPlayerVar( "config_pb_practise","on" );
	SetCurrentPlayerVar ( "top_bottom_coordinate", 70);
	SetCurrentPlayerVar ( "left_right_coordinate", 1);
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_display_mode_text ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode_graphical","off" );
	SetCurrentPlayerVar( "config_pb_display_mode_text","on" );
	SetCurrentPlayerVar( "config_pb_display_mode_off","off" );
	SetCurrentPlayerVar( "config_pb_practise","on" );
	SetCurrentPlayerVar( "config_pb_race","off" );
	SetCurrentPlayerVar( "config_pb_race_gaps","off" );
	SetCurrentPlayerVar( "config_pb_race_splits","off" );
	SetCurrentPlayerVar ( "top_bottom_coordinate", -1);
	SetCurrentPlayerVar ( "left_right_coordinate", -1);
	closePrivButton( "config_pb_race&config_pb_race_gaps&config_pb_race_splits" );
	closePrivButton( "config_pb_tb_coordinate_min&config_pb_tb_coordinate_value&config_pb_tb_coordinate_plus" );
	closePrivButton( "config_pb_lr_coordinate_min&config_pb_lr_coordinate_value&config_pb_lr_coordinate_plus" );
	closePrivButton( "config_pb_test_position&config_pb_test_end" );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_display_mode_off ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode_graphical","off" );
	SetCurrentPlayerVar( "config_pb_display_mode_text","off" );
	SetCurrentPlayerVar( "config_pb_display_mode_off","on" );
	SetCurrentPlayerVar( "config_pb_practise","off" );
	SetCurrentPlayerVar( "config_pb_race","off" );
	SetCurrentPlayerVar( "config_pb_race_gaps","off" );
	SetCurrentPlayerVar( "config_pb_race_splits","off" );
	SetCurrentPlayerVar ( "top_bottom_coordinate", -1);
	SetCurrentPlayerVar ( "left_right_coordinate", -1);
	closePrivButton( "config_pb_practise&config_pb_race&config_pb_race_gaps&config_pb_race_splits" );
	closePrivButton( "config_pb_tb_coordinate_min&config_pb_tb_coordinate_value&config_pb_tb_coordinate_plus" );
	closePrivButton( "config_pb_lr_coordinate_min&config_pb_lr_coordinate_value&config_pb_lr_coordinate_plus" );
	closePrivButton( "config_pb_test_position&config_pb_test_end" );
	closePrivButton( "config_pb_split_setting_value" );
	closePrivButton( "config_pb_spb_setting_endlap&config_pb_spb_setting_splits&config_pb_lost/gained_yes&config_pb_lost/gained_no" );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_practise( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_practise","on" );
	SetCurrentPlayerVar( "config_pb_race","off" );
	SetCurrentPlayerVar( "config_pb_race_gaps","off" );
	SetCurrentPlayerVar( "config_pb_race_splits","off" );
	closePrivButton( "config_pb_race_gaps&config_pb_race_splits" );
	close_pitboard( $KeyFlags );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_race( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race","on" );
	SetCurrentPlayerVar( "config_pb_practise","off" );
	close_pitboard( $KeyFlags );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_race_gaps( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race_gaps","on" );
	SetCurrentPlayerVar( "config_pb_race_splits","off" );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_race_splits( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race_gaps","off" );
	SetCurrentPlayerVar( "config_pb_race_splits","on" );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_tb_coordinate_min ( $KeyFlags,$id )
	$top_bottom_coordinate=GetCurrentPlayerVar ( "top_bottom_coordinate")+0;

	IF ($KeyFlags == 1)
	THEN
	  IF ($top_bottom_coordinate >= 1)
	  THEN
	    $top_bottom_coordinate=$top_bottom_coordinate-1;
	  ENDIF
	ELSE
	  IF ($KeyFlags == 2)
	  THEN
	    IF ($top_bottom_coordinate >= 5)
	    THEN
	      $top_bottom_coordinate=$top_bottom_coordinate-5;
	    ENDIF
	  ENDIF
	ENDIF

	SetCurrentPlayerVar ( "top_bottom_coordinate", $top_bottom_coordinate);
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_tb_coordinate_plus ( $KeyFlags,$id )
	$top_bottom_coordinate=GetCurrentPlayerVar ( "top_bottom_coordinate")+0;

	IF ($KeyFlags == 1)
	THEN
	  IF ($top_bottom_coordinate <= 199)
	  THEN
	    $top_bottom_coordinate=$top_bottom_coordinate+1;
	  ENDIF
	ELSE
	  IF ($KeyFlags == 2)
	  THEN
	    IF ($top_bottom_coordinate <= 195)
	    THEN
	      $top_bottom_coordinate=$top_bottom_coordinate+5;
	    ENDIF
	  ENDIF
	ENDIF

	SetCurrentPlayerVar( "top_bottom_coordinate", $top_bottom_coordinate );
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_lr_coordinate_min ( $KeyFlags,$id )
	$left_right_coordinate=GetCurrentPlayerVar ( "left_right_coordinate")+0;

	IF ($KeyFlags == 1)
	THEN
	  IF ($left_right_coordinate >= 1)
	  THEN
	    $left_right_coordinate=$left_right_coordinate-1;
	  ENDIF
	ELSE
	  IF ($KeyFlags == 2)
	  THEN
	    IF ($left_right_coordinate >= 5)
	    THEN
	      $left_right_coordinate=$left_right_coordinate-5;
	    ENDIF
	  ENDIF
	ENDIF

	SetCurrentPlayerVar ( "left_right_coordinate", $left_right_coordinate);
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_lr_coordinate_plus ( $KeyFlags,$id )
	$left_right_coordinate=GetCurrentPlayerVar ( "left_right_coordinate")+0;
	
	IF ($KeyFlags == 1)
	THEN
	  IF ($left_right_coordinate <= 199)
	  THEN
	    $left_right_coordinate=$left_right_coordinate+1;
	  ENDIF
	ELSE
	  IF ($KeyFlags == 2)
	  THEN
	    IF ($left_right_coordinate <= 195)
	    THEN
	      $left_right_coordinate=$left_right_coordinate+5;
	    ENDIF
	  ENDIF
	ENDIF

	SetCurrentPlayerVar ( "left_right_coordinate", $left_right_coordinate);
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_test_position ( $KeyFlags,$id )
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	THEN
	  IF ( GetCurrentPlayerVar ("lost_gained_messages") == "yes")
	  THEN
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,46,5,-1,32,"");
	  ELSE
	    openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "left_right_coordinate"),GetCurrentPlayerVar ( "top_bottom_coordinate"),32,42,5,-1,32,"");
	  ENDIF
	  openPrivButton( "pitboard_txt",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+1,30,4,4,-1,0,"^7Pitboard:^0 " . GetCurrentPlayerVar( "Nickname" ) );
	ELSE
	  privMsg ("^7Pitboard is switched off" );
	  privMsg ("^7Test can not be done" );
	ENDIF
EndSub

Sub config_pb_test_end ( $KeyFlags,$id )
	closePrivButton( "pitboard_total&pitboard_txt&pitboard_start_pitwindow&pitboard_end_pitwindow&pitboard_pw_stops");
	closePrivButton( "pitboard_start_pitwindow_lap&pitboard_end_pitwindow_lap&pitboard_number_of_stops&pitboard_no_pitwindow");
EndSub

Sub config_pb_split_setting_value ( $split_setting )
	SetCurrentPlayerVar ("split_setting", $split_setting);
	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_spb_setting ( $KeyFlags,$id )
	IF ( GetCurrentPlayerVar ("spb_setting") == "end")
	THEN
	  SetCurrentPlayerVar ("spb_setting", "splits");
	ELSE
	  SetCurrentPlayerVar ("spb_setting", "end");
	ENDIF

	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_lost_gained_setting ( $KeyFlags,$id )
	IF ( GetCurrentPlayerVar ("lost_gained_messages") == "no")
	THEN
	  SetCurrentPlayerVar( "lost_gained_messages", "yes" );
	  IF ( GetCurrentPlayerVar ( "config_pb_display_mode_graphical") == "on" )
	  THEN
	    PrivMsg ("^1Warning! ^7Pitboardlength increased by 4");
	  ENDIF
	ELSE
	  SetCurrentPlayerVar( "lost_gained_messages", "no" );
	  IF ( GetCurrentPlayerVar ( "config_pb_display_mode_graphical") == "on" )
	  THEN
	    PrivMsg ("^1Warning! ^7Pitboardlength decreased by 4");
	    closePrivButton( "pitboard_information_2" );
	  ENDIF
	ENDIF

	Config_Pitboard( $KeyFlags );
EndSub

Sub config_pb_save_settings ( $KeyFlags,$id )
	$userName = GetCurrentPlayerVar( "UserName" );
	SetStoredValue( $userName . "config_pb_display_mode_graphical", GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) );
	SetStoredValue( $userName . "config_pb_display_mode_text", GetCurrentPlayerVar( "config_pb_display_mode_text" ) );
	SetStoredValue( $userName . "config_pb_display_mode_off", GetCurrentPlayerVar( "config_pb_display_mode_off" ) );
	SetStoredValue( $userName . "config_pb_practise", GetCurrentPlayerVar( "config_pb_practise" ) );
	SetStoredValue( $userName . "config_pb_race", GetCurrentPlayerVar( "config_pb_race" ) );
	SetStoredValue( $userName . "config_pb_race_gaps", GetCurrentPlayerVar( "config_pb_race_gaps" ) );
	SetStoredValue( $userName . "config_pb_race_splits", GetCurrentPlayerVar( "config_pb_race_splits" ) );
	SetStoredValue( $userName . "top_bottom_coordinate", GetCurrentPlayerVar( "top_bottom_coordinate" ) );
	SetStoredValue( $userName . "left_right_coordinate", GetCurrentPlayerVar( "left_right_coordinate" ) );
	SetStoredValue( $userName . "split_setting", GetCurrentPlayerVar( "split_setting" ) );
	SetStoredValue( $userName . "spb_setting", GetCurrentPlayerVar( "spb_setting" ) );
	SetStoredValue( $userName . "lost_gained_messages", GetCurrentPlayerVar( "lost_gained_messages" ) );
	privMsg ("^7Settings saved" );
EndSub

Sub config_pb_close( $KeyFlags,$id )
	### Close buttons config screen Pitboard ###
	closePrivButton( "config_pb_display_mode_txt&config_pb_display_mode_graphical&config_pb_display_mode_text&config_pb_display_mode_off&config_pb_information_mode_txt" );
	closePrivButton( "config_pb_bg&config_pb_title&config_pb_practise&config_pb_race&config_pb_race_gaps&config_pb_race_splits" );
	closePrivButton( "config_pb_tb_coordinate&config_pb_tb_coordinate_min&config_pb_tb_coordinate_value&config_pb_tb_coordinate_plus" );
	closePriVButton( "config_pb_lr_coordinate&config_pb_lr_coordinate_min&config_pb_lr_coordinate_value&config_pb_lr_coordinate_plus" );
	closePrivButton( "config_pb_test_position&config_pb_test_end&config_pb_split_setting_txt&config_pb_split_setting_value&config_pb_save_settings" );
	closePrivButton( "config_pb_spb_setting_txt&config_pb_spb_setting_splits&config_pb_spb_setting_endlap&config_pb_lost/gained_txt&config_pb_lost/gained_yes&config_pb_lost/gained_no&config_pb_close" );
	### End ###

	### Close Pitboard when Text of Off mode is selected ###
	IF ( GetCurrentPlayerVar( "config_pb_display_mode_text" ) == "on" || GetCurrentPlayerVar( "config_pb_display_mode_off" ) == "on" )
	THEN
	  close_pitboard( $KeyFlags );
	ELSE
	  OnNewPlayerJoin_Pitboard();
	ENDIF
	### End ###
EndSub

Sub close_pitboard( $KeyFlags )
	closePrivButton( "pitboard_total&pitboard_txt&pitboard_start_pitwindow&pitboard_end_pitwindow&pitboard_pw_stops");
	closePrivButton( "pitboard_start_pitwindow_lap&pitboard_end_pitwindow_lap&pitboard_number_of_stops&pitboard_no_pitwindow");	
	closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	closePrivButton( "pitboard_information&pitboard_information_2" );
	closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
EndSub

Sub Pitwindow( $KeyFlags )
	OpenPrivButton( "pitwindow_bg",75,75,50,57,5,-1,16,"");
	OpenPrivButton( "pitwindow_title",76,76,48,5,5,-1,32,"^7Current set Pitwindow(s):");
	OpenPrivButton( "pitwindow_1",76,86,15,5,5,-1,0,"^7Pitwindow 1:");
	OpenPrivButton( "pitwindow_1_start",92,86,15,5,5,-1,96,"^2Start: " . $start_window_1);
	OpenPrivButton( "pitwindow_1_end",109,86,15,5,5,-1,96,"^1End: " . $end_window_1);
	OpenPrivButton( "pitwindow_2",76,96,15,5,5,-1,0,"^7Pitwindow 2:");
	OpenPrivButton( "pitwindow_2_start",92,96,15,5,5,-1,96,"^2Start: " . $start_window_2);
	OpenPrivButton( "pitwindow_2_end",109,96,15,5,5,-1,96,"^1End: " . $end_window_2);
	OpenPrivButton( "pitwindow_3",76,106,15,5,5,-1,0,"^7Pitwindow 3:");
	OpenPrivButton( "pitwindow_3_start",92,106,15,5,5,-1,96,"^2Start: " . $start_window_3);
	OpenPrivButton( "pitwindow_3_end",109,106,15,5,5,-1,96,"^1End: " . $end_window_3);
	OpenPrivButton( "pitwindow_blackflag",76,116,35,5,5,-1,0,"^7Laps before getting black flag: ");
	OpenPrivButton( "pitwindow_blackflag_2",114,116,10,5,5,-1,32, "^7" . $penalty_laps);
	OpenPrivButton( "pitwindow_close",76,126,48,5,5,-1,32, "^3Close", pitwindow_close);
EndSub

Sub pitwindow_close ( $KeyFlags,$id )
	closePrivButton( "pitwindow_bg&pitwindow_title&pitwindow_1&pitwindow_1_start&pitwindow_1_end&pitwindow_2&pitwindow_2_start&pitwindow_2_end&pitwindow_3&pitwindow_3_start&pitwindow_3_end" );
	closePrivButton( "pitwindow_blackflag&pitwindow_blackflag_2&pitwindow_close" );
EndSub

Sub OnRaceStart_Pitboard() # Lapper event

	IF ($start_window_1 == "")
	THEN
	  cmdLFS( "/rcm ^3Clean racing and have fun :-)" );
	ELSE
	  cmdLFS( "/rcm ^7Pitwindow is set to: ^2" . $start_window_1 . " ^7- ^1" . $end_window_1 );
	ENDIF
	cmdLFS( "/rcm_all" );

	### Set numbers of stops for every window on every player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] != "")
		THEN
		  $user_array[$i,2] = $number_of_stops_w1;
		  $user_array[$i,3] = $number_of_stops_w2;
		  $user_array[$i,4] = $number_of_stops_w3;
		  $user_array[$i,6] = 1; # Set player status to: not ready
		  $user_array[$i,7] = 0; # Set go to pitlane exit to: not done
		  $user_array[$i,8] = 0; # Set start qualify to: not done
		ENDIF
	ENDFOR
	### End ###

	### Set $qualify to off ###
	$qualify="off";
	### End ###

EndSub

Sub OnQualStart_Pitboard() # Lapper event

	### Set numbers of stops for every window on every player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] != "")
		THEN
		  $user_array[$i,2] = 0;
		  $user_array[$i,3] = 0;
		  $user_array[$i,4] = 0;
		  $user_array[$i,6] = 1; # Set player status to: not ready
		  $user_array[$i,7] = 0; # Set go to pitlane exit to: not done
		  $user_array[$i,8] = 0; # Set start qualify to: not done
		ENDIF
	ENDFOR
	### End ###

	### Set $qualify to on ###
	$qualify="on";
	### End ###

EndSub

Sub OnEndPit_Pitboard()  # Player event

	$Penalty_check = GetCurrentPlayerVar( "Penalty_check" );

	### Check if Pitstop is inside Window 1,2,3 ###
	### Reduce number of stops for that window by 1 ###
	### Display button with remaining number of stops for that window ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_1-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1)
		  THEN
		    IF ($user_array[$i,2] > 0)
		    THEN
		      $user_array[$i,2]=$user_array[$i,2]-1;
		      IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_2-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		  THEN
		    IF ($user_array[$i,3] > 0)
		    THEN
		      IF ($Penalty_check == "false") # Check wether a penalty is active, if so: pitstop doesn't count
		      THEN
		        $user_array[$i,3]=$user_array[$i,3]-1;
		      ENDIF

		      IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_3-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_3)
		  THEN
		    IF ($user_array[$i,4] > 0)
		    THEN
		      IF ($Penalty_check == "false") # Check wether a penalty is active, if so: pitstop doesn't count
		      THEN
		        $user_array[$i,4]=$user_array[$i,4]-1;
		      ENDIF

		      IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		      ENDIF
		    ENDIF
		  ENDIF
		
		ENDIF
	ENDFOR
	### End ###

	### Check if Penalty is active and if so, set it to false ###
	### Set remaining stops for that window to 0 and update button ###
	IF ($Penalty_check != "false")
	THEN
	  SetCurrentPlayerVar("Penalty_check","false");
	  SetCurrentPlayerVar("Penalty_laps",$penalty_laps);
	  SetCurrentPlayerVar("Information","");
	  FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ($Penalty_check == "true_window_1")
		  THEN
		    $user_array[$i,2] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ENDIF
		  ENDIF

		  IF ($Penalty_check == "true_window_2")
		  THEN
		    $user_array[$i,3] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		    ENDIF
		  ENDIF

		  IF ($Penalty_check == "true_window_3")
		  THEN
		    $user_array[$i,4] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "left_right_coordinate")+21,GetCurrentPlayerVar ( "top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
		    ENDIF
		  ENDIF
		ENDIF
	  ENDFOR

	  IF ( GetCurrentPlayerVar( "config_pb_display_mode_graphical" ) == "on" )
	  THEN
	    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "left_right_coordinate")+1,GetCurrentPlayerVar ( "top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
	  ENDIF
   	ENDIF
	### End ###

EndSub

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No
Sub OnChangeTyres_Pitboard( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_1-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_2-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_3-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_3)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

EndSub

Sub check_tyre_change( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )
	IF ($force_tyre_change == "Yes")
	THEN
	  IF ($FL_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreFrontLeft") == GetCurrentPlayerVar ("TyreFrontLeft") )
	    THEN
	      PrivMsg ("^1Tyre compound FL not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre FL not changed");
	  ENDIF

	  IF ($FR_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreFrontRight") == GetCurrentPlayerVar ("TyreFrontRight") )
	    THEN
	      PrivMsg ("^1Tyre compound FR not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre FR not changed");
	  ENDIF

	  IF ($RL_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreRearLeft") == GetCurrentPlayerVar ("TyreRearLeft") )
	    THEN
	      PrivMsg ("^1Tyre compound RL not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre RL not changed");
	  ENDIF

	  IF ($RR_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreRearRight") == GetCurrentPlayerVar ("TyreRearRight") )
	    THEN
	      PrivMsg ("^1Tyre compound RR not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre RR not changed");
	  ENDIF
	ENDIF
EndSub