/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections.Generic;
using System.Text;

namespace GLScript
{
    public class SetOfVars
    {
        public System.Collections.Hashtable globVars = new System.Collections.Hashtable();
        public bool globalExist(string id)
        {
            string[] ids = id.Split(',');
            return (globVars.Contains(ids[0]));
        }

        private System.Collections.Hashtable vars = new System.Collections.Hashtable();
        public enum typVar
        {
            val,
            array,
        }
        public class var
        {
            public typVar typ;
            public object obj;
            public var(typVar ptyp, object pobj)
            {
                this.typ = ptyp;
                this.obj = pobj;
            }
        }
        public SetOfVars()
        {
        }
        public void raz(){
            vars.Clear();
        }
        public void unSet(string id)
        {
            if( vars.Contains( id ) )
                vars.Remove(id);
        }
        public void Set(string id, unionVal obj)
        {
            string[] ids = id.Split(',');

                
            if ( ids.Length > 1 )
            {
                if( !vars.Contains( ids[0] ) )
                    vars[ids[0]] = new var(typVar.array, new SetOfVars());

                if( ( vars[ids[0]] as var).typ == typVar.val )
                    throw new ParseException("You can't change the dimension of an array... ");
                ((vars[ids[0]] as var).obj as SetOfVars).Set(string.Join(",", ids, 1, ids.Length - 1), obj);
                return;
            }
            if (!vars.Contains(ids[0]))
                vars[id] = new var(typVar.val, obj);
            else
            {
                if ((vars[ids[0]] as var).typ == typVar.array)
                    throw new ParseException("You can't change the dimension of an array... ");
                vars[id] = new var(typVar.val, obj);
            }
        }
        public unionVal Get( string id )
        {
            string[] ids = id.Split(',');
            if (ids.Length > 1)
            {
                if (!vars.Contains(ids[0]))
                    return new unionVal(0, "\"\"", typVal.str);
                if( (vars[ids[0]] as var).typ == typVar.array )
                    return ((vars[ids[0]] as var).obj as SetOfVars).Get(string.Join(",", ids, 1, ids.Length - 1));
                else
                    return new unionVal(0, "\"Wrong dimension Array\"", typVal.str);
            }
            if( vars.ContainsKey( id ) ){
                if ((vars[ids[0]] as var).typ != typVar.array)
                    return ((unionVal)(vars[id] as SetOfVars.var).obj);
                else
                    return new unionVal(0, "\"Array\"", typVal.str);
            }
            else
                return new unionVal( 0,"\"\"",typVal.str );

        }

 
    }

}
