/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections.Generic;
using System.Text;

namespace GLScript
{

    public class TokenBuffer
    {
        public System.Collections.ArrayList TokenList = new System.Collections.ArrayList();
        public class token
        {
            public int typ;
            public string fileName;
            public int lineNumber;
            public string value;
            public token(int ptyp, string pfileName, int pLine, string pvalue)
            {
                this.typ = ptyp;
                this.fileName = pfileName;
                this.lineNumber = pLine;
                this.value = pvalue;
            }
        }
        public TokenBuffer(string str, string fileName, int StartLineInSrc)
        {
            createTokenBuffer(str, fileName, StartLineInSrc);
        }
        void createTokenBuffer(string str, string fileName, int StartLineInSrc)
        {
            int tok;
            //            Console.WriteLine("Chaine  traiter :" + str);
            string currFile = fileName;
            int currLine = StartLineInSrc;
            Scanner scnr = new Scanner();
            scnr.SetSource(str, 0);
            while (true)
            {
                tok = scnr.yylex();
                if (tok == (int)Tokens.EOF || tok == Scanner.E_END)
                    break;
                string yytext = scnr.yytext;
                if (tok == GLScript.Scanner.E_IDENT)
                {
                    if (scnr.yytext == "FILE__")
                    {
                        tok = scnr.yylex(); //  = 
                        tok = scnr.yylex(); // Value
                        currFile = UTILS.utils.unquote(scnr.yytext);
                        tok = scnr.yylex(); // ;
                        continue;
                    }
                    else if (scnr.yytext == "LINE__")
                    {
                        tok = scnr.yylex(); //  = 
                        tok = scnr.yylex(); // Value
                        currLine = int.Parse(scnr.yytext);
                        tok = scnr.yylex(); // ;
                        continue;
                    }
                }
                TokenList.Add(new token(tok, currFile,currLine, yytext));
            }
        }
    }
}
