/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections;
using System.Text;
using System.Text.RegularExpressions;
using LFSLapper;
using Configurator;


namespace LFSLapper
{
    partial class LFSClient
    {
        private string quote(string str)
        {
            return "\"" + str + "\"";
        }
        public void retreiveVarLapper(GLScript.unionVal val, string idVar )
        {
            #region globalVar
            switch (idVar.ToLower())
            {

                case "rotatein":
                    val.typVal = GLScript.typVal.num;
                    if (newCfg.varsLapper.EnableRotation)
                        val.fval = newCfg.varsLapper.RotateEveryNbRaces - currRace.racesDone;
                    else
                        val.fval = 0;
                    return;
                case "racelapsleft":
                    val.typVal = GLScript.typVal.num;
                    if (currRace.inRace)
                        val.fval = currRace.raceLapsLeft;
                    else
                        val.fval = 0;
                    return;
/*
                case "maxcarresets":
                    val.typVal = GLScript.typVal.num;
                    if (currRace.inRace)
                        val.fval = newCfg.varsLapper.MaxCarResets;
                    else
                        val.fval = 0;
                    return;
*/
                case "hostname":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(currentHName);
                    return;
                case "shorttrackname":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(currState.ShortTrackName);
                    return;
                case "longtrackname":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(UTILS.utils.getLongTrackName(currState.ShortTrackName));
                    return;
                case "shorttime":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(System.DateTime.Now.ToShortTimeString());
                    return;
                case "longtime":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(System.DateTime.Now.ToLongTimeString());
                    return;
                case "shortdate":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(System.DateTime.Now.ToString(newCfg.varsLapper.DateFormat));
                    return;
                case "longdate":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(System.DateTime.Now.ToString(newCfg.varsLapper.LongDateFormat));
                    return;
                case "nextrotatecar":
                    {
                        val.typVal = GLScript.typVal.str;
                        int nextCar = currRace.currRotateCar + 1;
                        string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                        if (nextCar > tmpCars.Length - 1)
                            nextCar = 0;
                        val.sval = quote(tmpCars[nextCar]);
                    }
                    return;
                case "nextrotatetrack":
                case "nextlongrotatetrack":
                    {
                        val.typVal = GLScript.typVal.str;
                        int nextTrack = currRace.currRotateTrack + 1;
                        string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                        if (nextTrack > tmpTracks.Length - 1)
                            nextTrack = 0;
                        if (idVar == "nextrotatetrack")
                            val.sval = quote(tmpTracks[nextTrack]);
                        else
                            val.sval = quote(UTILS.utils.getLongTrackName(tmpTracks[nextTrack]));

                    }
                    return;
                case "currrotatecar":
                    {
                        val.typVal = GLScript.typVal.str;
                        int nextCar = currRace.currRotateCar;
                        string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                        if (nextCar > tmpCars.Length - 1)
                            nextCar = 0;
                        val.sval = quote(tmpCars[nextCar]);
                    }
                    return;
                case "currrotatetrack":
                case "currlongrotatetrack":
                    {
                        val.typVal = GLScript.typVal.str;
                        int nextTrack = currRace.currRotateTrack;
                        string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                        if (nextTrack > tmpTracks.Length - 1)
                            nextTrack = 0;
                        if (idVar == "CurrRotateTrack")
                            val.sval = quote(tmpTracks[nextTrack]);
                        else
                            val.sval = quote(UTILS.utils.getLongTrackName(tmpTracks[nextTrack]));
                    }
                    return;
                case "requiredflags":
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(sFlagsRequired);
                    return;
                case "nbplayersontrack":
                    val.typVal = GLScript.typVal.num;
                    val.fval = listOfPlayers.nbPlayerOnTrack;
                    return;
                case "racelaps":
                    val.typVal = GLScript.typVal.num;
                    val.fval = currRace.raceLaps;
                    return;
                case "racemins":
                    val.typVal = GLScript.typVal.num;
                    val.fval = currRace.qualMins;
                    return;

                default:
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote("");
                    return;
            }
            #endregion
        }
        public void SetVarPlayer(GLScript.unionVal val, string idVar, string userName, string value)
        {
            infoPlayer currInfoPlayer = null;
            if (userName != "")
                currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);
            if (currInfoPlayer != null)
            {
                currInfoPlayer.playerVars.Set(idVar, new GLScript.unionVal(0, quote(value), GLScript.typVal.str));
            }
            val.typVal = GLScript.typVal.str;
            val.sval = quote( value );
        }
        public void GetVarPlayer(GLScript.unionVal val, string idVar, string userName)
        {
            infoPlayer currInfoPlayer = null;
            if( userName != "" )
                currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);

            #region Var currInfoPlayer
            if (currInfoPlayer == null)
            {
                val.typVal = GLScript.typVal.str;
                val.sval = quote("");
                return;
            }
            else
            {
                switch (idVar.ToLower())
                {
                    // AlphaNumeric return
                    case "nickname":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(currInfoPlayer.nickName);
                        break;
                    case "username":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(currInfoPlayer.userName);
                        break;
                    case "car":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(currInfoPlayer.CName);
                        break;
                    case "pitwork":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(currInfoPlayer.pitWork);
                        break;
                    case "playerflags":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(currInfoPlayer.sPlayerFlags);
                        break;
                    case "posabs":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, false);
                            if (tmpPosQualUser.posUser != 0)
                                val.sval = quote(tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                            else
                                val.sval = quote("-/-");
                        }
                        break;
                    case "groupqual":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, true);
                            if (tmpPosQualUser.groupUser != -1)
                                val.sval = quote(((char)(tmpPosQualUser.groupUser + 65)).ToString());
                            else
                                val.sval = quote("-");
                        }
                        break;
                    case "posqual":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, true);
                            if (tmpPosQualUser.posUser != 0)
                                val.sval = quote(tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                            else
                                val.sval = quote("-/-");
                        }
                        break;
                    case "unitspeed":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(getUnitSpeed(currInfoPlayer.unitSpeedKmh));
                        break;
                    case "unitdist":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(getUnitDist(currInfoPlayer.unitSpeedKmh));
                        break;
                    case "typ":
                        val.typVal = GLScript.typVal.str;
                        if (currInfoPlayer.viewSPBSplit == 'P')
                            val.sval = quote("PB");
                        else if (currInfoPlayer.viewSPBSplit == 'S')
                            val.sval = quote("Sess");
                        else if (currInfoPlayer.viewSPBSplit == 'W')
                            val.sval = quote("WR");
                        else
                            val.sval = quote("typ");
                        break;
                    case "dist":
                        {
                            val.typVal = GLScript.typVal.str;
                            double len = trackInfo.getLen(currState.ShortTrackName);
                            int dist = (int)(len * (double)currInfoPlayer.gripDriverLapInfo.laps);
//                            val.sval = quote(unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)dist).ToString("0") + " " + getUnitDist(currInfoPlayer.unitSpeedKmh));
                            val.sval = quote(dist.ToString("0"));
                        }
                        break;
                    case "sessdist":
                        {
                            val.typVal = GLScript.typVal.str;
                            double len = trackInfo.getLen(currState.ShortTrackName);
                            int sess_dist = (int)(len * (double)currInfoPlayer.sessLaps);
//                            val.sval = quote(unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)sess_dist).ToString("0") + " " + getUnitDist(currInfoPlayer.unitSpeedKmh));
                            val.sval = quote(sess_dist.ToString("0"));
                        }
                        break;
                    case "unamebehind":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
                            val.sval = quote(currInfoPlayer.UNameBehind);
                        else
                            val.sval = quote("");
                        break;

                    case "gapbehind":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
                            val.sval = quote(currInfoPlayer.gapBehind);
                        else
                            val.sval = quote("");
                        break;
                    case "unamebefore":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
                            val.sval = quote(currInfoPlayer.UNameBefore);
                        else
                            val.sval = quote("");
                        break;
                    case "gapbefore":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
                            val.sval = quote(currInfoPlayer.gapBefore);
                        else
                            val.sval = quote("");
                        break;
                    case "oldtyrerearleft":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreRearLeft));
                        break;
                    case "oldtyrerearright":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreRearRight));
                        break;
                    case "oldtyrefrontleft":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreFrontLeft));
                        break;
                    case "oldtyrefrontright":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreFrontRight));
                        break;
                    case "tyrerearleft":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreRearLeft));
                        break;
                    case "tyrerearright":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreRearRight));
                        break;
                    case "tyrefrontleft":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreFrontLeft));
                        break;
                    case "tyrefrontright":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreFrontRight));
                        break;
                    case "authlevel":
                        val.typVal = GLScript.typVal.str;
                        val.sval = quote(StringLevelsAllowedPlayer(currInfoPlayer,true));
                        break;
                    // Numeric return
                    case "numcarresets":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.NumCarResets;
                        break;
                    case "laps":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.gripDriverLapInfo.laps;
                        break;
                    case "pos":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.currPos;
                        break;
                    case "sesslaps":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sessLaps;
                        break;
                    case "totalpittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.totalPitTime;
                        break;
                    case "pittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.pitTime;
                        break;
                    case "swearwordsrem":
                        val.typVal = GLScript.typVal.num;
                        val.fval = newCfg.varsLapper.SwearWordsMax - currInfoPlayer.swearWordsCount;
                        break;
                    case "lapsdone":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lapsDone;
                        break;
                    case "p_mass": // Player Current Mass
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.P_Mass;
                        break;
                    case "p_tres": // Player CUrrent Restriction
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.P_TRes;
                        break;
                    case "h_mass": // Player required Mass
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.H_Mass;
                        break;
                    case "h_tres": // Player Required restriction
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.H_TRes;
                        break;
                    case "split1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[0];
                        break;
                    case "split2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[1];
                        break;
                    case "split3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[2];
                        break;
                    case "laptime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lapTime;
                        break;
                    case "pblaptime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.gripDriverLapInfo.personalBestLapTime;
                        break;
                    case "difflaptimetopb":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffLapTimeToPb;
                        break;
                    case "splittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lastSplitTime;
                        break;
                    case "sectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[0];
                        break;
                    case "sectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[1];
                        break;
                    case "sectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[2];
                        break;
                    case "sectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplitLast;
                        break;
                    case "bestsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[0];
                        break;
                    case "bestsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[1];
                        break;
                    case "bestsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[2];
                        break;
                    case "bestsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplitLast;
                        break;
                    case "diffsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[0];
                        break;
                    case "diffsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[1];
                        break;
                    case "diffsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[2];
                        break;
                    case "diffsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplitLast;
                        break;
                    case "isbestsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[0])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[1])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[2])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplitLast)
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "avgspeed":
                        val.typVal = GLScript.typVal.num;
                        //val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, trackInfo.getAvgSpeed(currState.ShortTrackName, currInfoPlayer.lapTime))));
                        val.fval = float.Parse(string.Format("{0:n}", trackInfo.getAvgSpeed(currState.ShortTrackName, currInfoPlayer.lapTime)));
                        break;
                    case "instantspeed":
                        val.typVal = GLScript.typVal.num;
//                        val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.instantSpeed)));
                        val.fval = float.Parse(string.Format("{0:n}", currInfoPlayer.instantSpeed));
                        break;
                    case "bestspeed":
                        val.typVal = GLScript.typVal.num;
//                        val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.instantSpeed)));
                        val.fval = float.Parse(string.Format("{0:n}", currInfoPlayer.bestSpeed));
                        break;
                    case "tpb":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.TPb;
                        break;
                    case "driftscore":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.totaldriftscore.ToString("F0"));
                        break;
                    case "anglevelocity":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.AngVel.ToString("F0"));
                        break;
                    case "lastdriftscore":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.lastdriftscore.ToString("F0"));
                        break;
                    case "accelerationstartspeed":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeed.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeedMph.ToString("F0"));
                        break;
                    case "accelerationendspeed":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeed.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeedMph.ToString("F0"));
                        break;
                    case "accelerationtime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.accelerationTime.TotalSeconds.ToString("F1"));
                        break;
                    case "maxallowedlaptime1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime1 / 100) * ((double)currInfoPlayer.MaxLapTime));
                        break;
                    case "maxallowedlaptime2":
                        val.typVal = GLScript.typVal.num;
                        if (newCfg.varsLapper.MaxAllowedLapTime2 != 1)
                            val.fval = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime2 / 100) * ((double)currInfoPlayer.MaxLapTime));
                        else
                            val.fval = -1;
                        break;
                    case "remainfdip":
                        val.typVal = GLScript.typVal.num;
                        if (newCfg.varsLapper.MaxFastDriveOnPit != 99999)
                            val.fval = newCfg.varsLapper.MaxFastDriveOnPit - currInfoPlayer.NbFastDriveOnPit;
                        else
                            val.fval = -1;
                        break;
                    case "finishedpos":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.finishedPos != -1)
                        {
                            val.fval = (float)currInfoPlayer.finishedPos + 1;
                        }
                        break;
                    case "racetotaltime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.raceTotalTime;
                        break;
                    case "racepbtime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.racePBTime;
                        break;
                    case "currnode":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.CurrNode;
                        break;
                    case "x":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.x;
                        break;
                    case "y":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.y;
                        break;
                    default:
                        GLScript.unionVal retVal = currInfoPlayer.playerVars.Get(idVar);
                        val.typVal = retVal.typVal;
                        val.sval = retVal.sval;
                        val.fval = retVal.fval;
                        break;
                }
            }
            #endregion

        }
        public void myFunctions( GLScript.unionVal val, ArrayList args)
        {

            //            val.sval = execCmd(val.nameVar.ToLower(), args, newCfg.getCurrInfoPlayer() );
            //            val.typVal = GLScript.typVal.str;
            execCmd(val, args, newCfg.getCurrInfoPlayer() );
            return;
        }

//        public string execCmd(string ident, System.Collections.ArrayList args, infoPlayer currInfoPlayer)
        public void execCmd(GLScript.unionVal val, System.Collections.ArrayList args, infoPlayer currInfoPlayer)
        {
//            if (val.nameVar.ToLower() == "setcurrentplayervar")
//                Console.WriteLine("ICI");

/*
            for (int i = 0; i < args.Count; i++)
            {
                int l = args[i].ToString().Length;
                if (l > 1)
                {
                    if (args[i].ToString()[0] == '"' && args[i].ToString()[l - 1] == '"')
                    {
                        args[i] = args[i].ToString().Substring(1, l - 2);
                    }
                }
            }
*/
            bool flagDesc = false;
            string ident = val.nameVar.ToLower();
            switch (val.nameVar.ToLower())
            {

                 case "setplayervar":
                    testArgs(ident, "SSS", args);
                    SetVarPlayer(val,(string)args[1], (string)args[0], (string)args[2]);
                    return;
                case "getlappervar":
                    testArgs(ident, "S", args);
                    retreiveVarLapper(val,(string)args[0]);
                    return;
                case "getplayervar":
                    testArgs(ident, "SS", args);
                    GetVarPlayer(val,(string)args[1], (string)args[0]);
                    return;

                case "numtomsh":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    try
                    {
                        val.sval = quote(unitConv.LongToHMS(long.Parse((string)args[0])));
                    }
                    catch
                    {
                        val.sval = "";
                    }
                    return;
                case "mshtonum":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.num;
                    val.fval = unitConv.HMSToLong(args[0].ToString());
                    return;
                case "tokph":
                    testArgs(ident, "F", args);
                    val.typVal = GLScript.typVal.num;
                    val.fval = (float)unitConv.toKph(float.Parse(args[0].ToString()));
                    return;
                case "tomph":
                    testArgs(ident, "F", args);
                    val.typVal = GLScript.typVal.num;
                    val.fval = (float)unitConv.toMph(float.Parse(args[0].ToString()));
                    return;
                case "toplayerunit":
                    testArgs(ident, "F", args);
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    val.typVal = GLScript.typVal.num;
                    val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, float.Parse(args[0].ToString()))));
                    return;

                case "langtranslate":
                    {
                        string lang = "en";
                        if (args.Count < 1)
                            throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
                        if (currInfoPlayer != null)
                            lang = currInfoPlayer.idLang;
                        string tmpStr = (string)args[0];
                        tmpStr = lfsLang.replaceLangStr(lang, tmpStr);
                        args.RemoveAt(0);
                        try
                        {
                            val.sval = "\"" + string.Format(tmpStr, args.ToArray()) + "\"";
                        }
                        catch
                        {
                            val.sval = "\"" + "Wrong format " + tmpStr + "\"";
                        }
                        val.typVal = GLScript.typVal.str;
                        return;
                    }
                case "langengine":
                    {
                        if (args.Count < 1)
                            throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
                        string tmpStr = (string)args[0];
                        args.RemoveAt(0);
                        lfsLang.setParmsTranslate(tmpStr, args);
                        val.sval = "\"" + "[[TranslateEngine]]" + "\"";
                        val.typVal = GLScript.typVal.str;
                        return;
                    }
                case "termlapper":
                    TermProg = true;
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote("");
                    return;

                case "groupcmdlfs":
                    testArgs(ident, "S", args);
                    outgoingCmdStack.Push(args[0]);                
                    break;

                case "cmdlfs":
                    testArgs(ident, "S", args);

                    SendMsg(args[0].ToString()); 

                    break;
                case "setlicense":
                    testArgs(ident, "S", args);
                    {
                        string arg = args[0].ToString().Trim().ToLower();
                        if (arg == "on")
                        {
                            SendMsg("License ON");
                            SystemAuth.AuthOn = true;
                        }
                        if (arg == "off")
                        {
                            SendMsg( "License OFF");
                            SystemAuth.AuthOn = false;
                        }
                        if (arg == "?" || arg == "")
                        {
                            if (SystemAuth.AuthOn)
                                SendMsg("License Status = ON");
                            else
                                SendMsg("License Status = OFF");
                        }
                    }
                    break;
                case "setcurrentplayervar":
                    testArgs(ident, "SS", args);
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    SetVarPlayer(val, (string)args[0], currInfoPlayer.userName, (string)args[1]);
                    return;

                case "getcurrentplayervar":
                    testArgs(ident, "S", args);
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    GetVarPlayer(val, (string)args[0], currInfoPlayer.userName);
                    return;

                case "closetop":
                case "closedrf":
                case "closetopuser":
                    testArgs(ident, "", args);
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    closeAllTop(currInfoPlayer);
                    break;
                case "privmsg":
                    {
                        testArgs(ident, "S", args);
                        if (currInfoPlayer == null)
                            throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                        string text = args[0].ToString();
                        if (text == "[[TranslateEngine]]")
                            text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

                        SendMsgToConnection(currInfoPlayer.UCID, text );
                        break;
                    }
                case "globalmsg":
                    {
                        testArgs(ident, "S", args);
                        string text = args[0].ToString();
                        string newText = "";
                        foreach (DictionaryEntry de in listOfPlayers.playersUCID)
                        {
                            currInfoPlayer = (infoPlayer)de.Value;
                            if (text == "[[TranslateEngine]]")
                                newText = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                            else
                                newText = text;
                            SendMsgToConnection(currInfoPlayer.UCID, newText);
                        }
                        break;
                    }

                case "cleanspb":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    currInfoPlayer.splitLast = 0;
                    for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                        currInfoPlayer.sessBestSplitDiff[i] = 0;
                    currInfoPlayer.sessBestSplitDiffLast = 0;
                    currInfoPlayer.bestSpeed = (double)0;
                    SendMsgToConnection(currInfoPlayer.UCID, currInfoPlayer.nickName + "^8 SPB Cleaned");
                    break;
                case "showspb":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    string spb = "";
                    try
                    {
                        switch (currInfoPlayer.viewSPBSplit)
                        {
                            case 'W':
                            case 'P':
                                spb = "PB ";
                                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                                {
                                    if (currInfoPlayer.gripDriverLapInfo.PBBestSplitDiff[i] != 0)
                                        spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.gripDriverLapInfo.PBBestSplitDiff[i]);
                                }
                                if (currInfoPlayer.gripDriverLapInfo.PBBestSplitDiffLast != 0)
                                    spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.gripDriverLapInfo.PBBestSplitDiffLast);
                                break;
                            case 'S':
                                spb = "Sess ";
                                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                                {
                                    if (currInfoPlayer.sessBestSplitDiff[i] != 0)
                                        spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiff[i]);
                                }
                                if (currInfoPlayer.sessBestSplitDiffLast != 0)
                                    spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiffLast);
                                break;
                        }
                        SendMsgToConnection(currInfoPlayer.UCID, spb);
                        SendMsgToConnection(currInfoPlayer.UCID, unitConv.LongToHMS(currInfoPlayer.TPb));
                    }
                    catch (Exception) { }
                    break;
                case "showhand":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    if (newCfg.varsLapper.RefreshHandicapUsers)
                        UpdateHandicapUsers(newCfg.varsLapper.HandicapUsers);
                    ShowHand(currInfoPlayer, args[0].ToString());
                    break;  
                case "lapperversion":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    Ver(currInfoPlayer.UCID);
                    break;
                case "stats":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
                    break;
                case "dstats":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    ShowDriftStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
                    break;
                case "statsqual":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
                    break;
                case "dstatsqual":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    ShowDriftStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
                    break;

                case "topuser":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "SSSS", args);
                    flagDesc = false;
                    if (args[2].ToString().ToLower() == "desc")
                        flagDesc = true;
                    TopStoredUser(currInfoPlayer.UCID, args[0].ToString(), args[1].ToString(), currInfoPlayer.userName, currInfoPlayer.nickName, args[3].ToString(), false, flagDesc);
                    break;
                case "nearuser":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "SSSS", args);
                    flagDesc = false;
                    if (args[2].ToString().ToLower() == "desc")
                        flagDesc = true;
                    TopStoredUser(currInfoPlayer.UCID, args[0].ToString(), args[1].ToString(), currInfoPlayer.userName, currInfoPlayer.nickName, args[3].ToString(), true, flagDesc);
                    break;
                case "currentplayerlfsworldpb":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    lfsWorldPB(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), 0);
                    break;
                case "currentplayerlfsworldpbfrom":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "SI", args);
                    lfsWorldPB(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), int.Parse(args[1].ToString()));
                    break;
                case "top":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    TopGrip(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false, false);
                    break;
                case "drf":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(),false, false);
                    break;
                case "topqual":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    if (newCfg.varsLapper.RefreshQualUsers)
                        UpdateQualUsers(newCfg.varsLapper.QualUsers);
                    TopGrip(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true,false);
                    break;
                case "drfqual":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    if (newCfg.varsLapper.RefreshQualUsers)
                        UpdateQualUsers(newCfg.varsLapper.QualUsers);
                    TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true,false);
                    break;

                case "nearqual":
                    TopGrip(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true, true);
                    break;
                case "drfnearqual":
                    TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true, true);
                    break;
                case "near":
                    TopGrip(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false, true);
                    break;
                case "drfnear":
                    TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false, true);
                    break;
                case "openprivbutton":
                    {
                        if (currInfoPlayer == null)
                            throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                        if (args.Count == 9)
                            args.Add("");
                        testArgs(ident, "SIIIIIIISS", args);
                        string text = args[8].ToString();
                        if (text == "[[TranslateEngine]]")
                            text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                        currInfoPlayer.playerBox.create(
                                                            args[0].ToString(), // ID du boutton
                                                            currInfoPlayer.UCID,
                                                            int.Parse(args[1].ToString()), // X
                                                            int.Parse(args[2].ToString()), // Y
                                                            int.Parse(args[3].ToString()),  // Largeur
                                                            int.Parse(args[4].ToString()),  // Hauteur
                                                            int.Parse(args[5].ToString()),  // Interligne
                                                            int.Parse(args[6].ToString()), // Sec Visible
                                                            0,                              // TypeIn
                                                            int.Parse(args[7].ToString()),  // Bstyle
                                                            "",                             // Caption
                                                            text,             // Button Text
                                                            args[9].ToString()              // BackCall
                        );
                        currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
                        break;
                    }
                case "privrcm":
                    {
                        if (currInfoPlayer == null)
                            throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                        testArgs(ident, "S", args);
                        string text = args[0].ToString();
                        if (text == "[[TranslateEngine]]")
                            text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                        SendMsg("/rcm " + text);
                        SendMsg("/rcm_ply " + currInfoPlayer.nickName);
                        /*
                                            currInfoPlayer.playerBox.create("rcmpriv", currInfoPlayer.UCID, 31, 36, 140, 17, 17, 6, 0, 0, "", "^0" + UTILS.utils.stripLFSColor(args[0].ToString()));
                                            currInfoPlayer.playerBox.show("rcmpriv", currInfoPlayer.UCID);
                                            currInfoPlayer.playerBox.create("rcmpriv2",currInfoPlayer.UCID, 30, 36, 140, 17, 17, 6, 0, 0, "", args[0].ToString());
                                            currInfoPlayer.playerBox.show("rcmpriv2", currInfoPlayer.UCID);
                         */
                        break;
                    }
                case "textprivbutton":
                    {
                        if (currInfoPlayer == null)
                            throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                        if (args.Count == 9)
                            args.Add("");
                        testArgs(ident, "SS", args);
                        string text = args[1].ToString();
                        if (text == "[[TranslateEngine]]")
                            text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

                        currInfoPlayer.playerBox.update(
                                                            args[0].ToString(), // ID du boutton
                                                            currInfoPlayer.UCID,
                                                            text  // Button Text
                        );
                        currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
                        break;
                    }
                case "openprivtextbutton":
                    {
                        if (currInfoPlayer == null)
                            throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                        testArgs(ident, "SIIIIIISSIS", args);
                        string text = args[8].ToString();
                        if (text == "[[TranslateEngine]]")
                            text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

                        currInfoPlayer.playerBox.create(args[0].ToString(), // ID du boutton
                                                            currInfoPlayer.UCID,
                                                            int.Parse(args[1].ToString()),  // X
                                                            int.Parse(args[2].ToString()),  // Y
                                                            int.Parse(args[3].ToString()),  // Largeur
                                                            int.Parse(args[4].ToString()),  // Hauteur
                                                            int.Parse(args[5].ToString()),  // Interligne
                                                            -1,                              // Sec Visible
                                                            int.Parse(args[9].ToString()),  // TypeIn
                                                            int.Parse(args[6].ToString()),  // Bstyle
                                                            args[7].ToString(),             // Caption
                                                            text,            // Button Text
                                                            args[10].ToString()             // BackCall
                        );
                        currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
                        break;
                    }
                case "privdelayedcommand":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "IS", args);
                    currInfoPlayer.tasks.Add(new Task(args[1].ToString(), System.DateTime.Now + new System.TimeSpan(0, 0, int.Parse(args[0].ToString()))));
                    break;
                case "myconfig":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    showConfigPlayer(currInfoPlayer);
                    break;
                case "setuserstoredvalue":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "SI", args);
                    storedSqlDbs.updateRowUser( args[0].ToString(), currInfoPlayer.userName,currInfoPlayer.nickName, float.Parse( args[1].ToString() ));
                    break;

                case "getuserstoredvalue":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(storedSqlDbs.retreiveRowUser(args[0].ToString(), currInfoPlayer.userName ));
                    return;

                case "openglobalbutton":
                    if (args.Count == 9)
                        args.Add("");
                    testArgs(ident, "SIIIIIIISS", args);
                    listOfPlayers.globalButtonMessage(args[0].ToString(),
                                                        int.Parse(args[1].ToString()),
                                                        int.Parse(args[2].ToString()),
                                                        int.Parse(args[3].ToString()),
                                                        int.Parse(args[4].ToString()),
                                                        int.Parse(args[5].ToString()),
                                                        int.Parse(args[6].ToString()),
                                                        0,
                                                        int.Parse(args[7].ToString()),
                                                        "",
                                                        args[8].ToString(),
                                                        args[9].ToString()
                    );
                    break;
                case "globalrcm":
                    {
                        testArgs(ident, "S", args);

                        string newText = "";
                        string text = args[0].ToString();
                        foreach (DictionaryEntry de in listOfPlayers.playersUCID)
                        {
                            currInfoPlayer = (infoPlayer)de.Value;
                            if (text == "[[TranslateEngine]]")
                                newText = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                            else
                                newText = text;
                            SendMsg("/rcm " + newText);
                            SendMsg("/rcm_ply " + currInfoPlayer.nickName);
                        }
                    }
                    break;


                    listOfPlayers.globalButtonMessage("rcmglobal", 31, 36, 140, 17, 17, 6, 0, 0, "", "^0" + UTILS.utils.stripLFSColor(args[0].ToString()), "");
                    listOfPlayers.globalButtonMessage("rcmglobal2", 30, 36, 140, 17, 17, 6, 0, 0, "", args[0].ToString(), "");
                    break;
                case "closeglobalbutton":
                    testArgs(ident, "S", args);
                    listOfPlayers.globalButtonClose( args[0].ToString() );
                    break;
                case "closeprivbutton":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    currInfoPlayer.privateButtonClose(args[0].ToString());
                    break;
                case "http":
                    if (currInfoPlayer == null)
                        throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                    testArgs(ident, "S", args);
                    objWebCmd.sendWebCmd( currInfoPlayer.UCID, args[0].ToString() );
                    break;
                case "moveusertogroup":
                    testArgs(ident, "SS", args);
                    uGroup.addUser(args[0].ToString(), args[1].ToString());
                    break;
                case "usergroupfromfile":
                    testArgs(ident, "SS", args);
                    uGroup.clear( args[0].ToString());
                    uGroup.addUserFromFile(args[0].ToString(),newCfg.varsLapper.WorkingDir + "/" + args[1].ToString());
                    break;
                case "removeuserfromgroup":
                    testArgs(ident, "SS", args);
                    uGroup.removeUser(args[0].ToString(), args[1].ToString());
                    break;
                case "cleargroup":
                    testArgs(ident, "S", args);
                    uGroup.clear(args[0].ToString());
                    break;
                case "useringroup":
                    testArgs(ident, "SS", args);
                    val.typVal = GLScript.typVal.num;
                    if (uGroup.userExist(args[0].ToString(), args[1].ToString()))
                        val.fval = 1;
                    else
                        val.fval = 0;

                    return;
                case "getusergrippb":
                    val.typVal = GLScript.typVal.num;
                    val.fval = gripSqlDbs.retreivePB(args[0].ToString(), args[0].ToString(), args[1].ToString(), args[2].ToString());
                    break;
                case "getuserdriftpb":
                    val.typVal = GLScript.typVal.num;
                    val.fval = (float)driftSqlDbs.retreiveDriftPoint(args[0].ToString(), args[0].ToString(), args[1].ToString(), args[2].ToString());
                    break;
                case "setstoredvalue":
                    testArgs(ident, "SS", args);
                    storedSqlDbs.updateRow(args[0].ToString(), args[1].ToString());
                    break;
                case "getstoredvalue":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(storedSqlDbs.retreiveRow(args[0].ToString()));
                    return;
                case "delayedcommand":
                    testArgs(ident, "IS", args);
                    Tasks.Add(new Task(args[1].ToString(), System.DateTime.Now + new System.TimeSpan(0, 0, int.Parse( args[0].ToString()) )));
                    break;
                case "getlongtrackname":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(UTILS.utils.getLongTrackName(args[0].ToString()));
                    break;
                case "getlengthtrack":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.num;
                    val.fval = UTILS.utils.getLenTrack(args[0].ToString());
                    break;
                case "getgrouptrack":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(UTILS.utils.getGroupTrack(args[0].ToString()));
                    break;
                case "getexttrack":
                    testArgs(ident, "S", args);
                    val.typVal = GLScript.typVal.str;
                    val.sval = quote(UTILS.utils.getExtTrack(args[0].ToString()));
                    break;
                case "registerscheduleaction":
                    testArgs(ident, "SS", args);
                    string[] cronTimer = args[0].ToString().Split(':');
                    for (int i = 0; i < cronTimer.Length; i++)
                        Tasks.Add(new Task(args[1].ToString(), cronTimer[i]));

                    break;
                case "registernodeaction":
                    testArgs(ident, "SIS", args);
                    listOfNodeEvent.Add(args[0].ToString(), int.Parse(args[1].ToString()), args[2].ToString());

                    break;
                case "registerzoneaction":
                    testArgs(ident, "SIIIS", args);
                    int x1 = int.Parse(args[1].ToString());
                    int y1 = int.Parse(args[2].ToString());
                    int dist = int.Parse(args[3].ToString());
                    listOfZoneEvent.Add(args[0].ToString(), x1,y1,dist, args[4].ToString());

                    break;
                default:
                    throw new GLScript.GLApp.GLScriptException("'" + ident + "' is not a Lapper function");
            }
        }
        void testArgs(string ident, string pattern, System.Collections.ArrayList args )
        {
            if (pattern.Length != args.Count)
            {
                throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
            }
            for( int i = 0; i < pattern.Length; i++ ){
                if (pattern[i] == 'I')
                {
                    try
                    {
                        int val = int.Parse(args[i].ToString());

                    }
                    catch
                    {
                        throw new GLScript.GLApp.GLScriptException("'" + ident + "' parameter #" + i.ToString() + " is wrong type at line #");
                    }
                }
                if (pattern[i] == 'F')
                {
                    try
                    {
                        float val = float.Parse(args[i].ToString());

                    }
                    catch
                    {
                        throw new GLScript.GLApp.GLScriptException("'" + ident + "' parameter #" + i.ToString() + " is wrong type at line #");
                    }
                }
            }
        }
    }

}
