using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace LFSLapper.LFSListen
{
    class Listen
    {
        LapperServer.infoInstance.autoStartVal autoStart;
        string ip;
        int port;
        string password;
        string workingDir;
        string iniFile;
        string superUsers;
        public bool TermProg = false;
        InSim.Connect insimConnection = null;
        public LFSClient myClient = null;
        private InSim.Encoder myEncoder = new InSim.Encoder();
        public bool startOk = false;
        GLDebug.Debug myDebug;
        static DateTime NextStartWork = DateTime.Now;
        static object obj = new object();




        public Listen(LapperServer.infoInstance.autoStartVal pautoStart, string pip, int pport, string ppassword, string pWorkingDir, string pInifile, string psuperUsers )
        {
            this.ip = pip;
            this.port = pport;
            this.password = ppassword;
            this.workingDir = pWorkingDir;
            this.iniFile = pInifile;
            this.superUsers = psuperUsers;
            this.autoStart = pautoStart;

            myDebug = new GLDebug.Debug( pWorkingDir + "/logs" );
            myDebug.AddDebugOutput( "err",pip + "-" + pport + "-ERR.log" );
            myDebug.AddDebugOutput( "mss",pip + "-" + pport + "-MSS.log" );


        }
        void SendMsgToConnection(int UCID, string msg)
        {
            if (msg.Length > 0)
            {
                if (UCID != -1)
                {
                    byte[] outMsg = myEncoder.MTC(UCID, 0, msg);
                    insimConnection.Send(outMsg, outMsg.Length);
                }
            }
        }
        void SendMsg( string msg)
        {
            if (msg.Length > 0)
            {
                byte[] outMsg = myEncoder.MST(msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        private void goWorkMode(){

            while (true)
            {
                lock (obj)
                {
                    if (NextStartWork < DateTime.Now)
                    {
                        NextStartWork = DateTime.Now.AddSeconds(paramLapper.secToNextWorkMode);
                        break;
                    }
                }
                System.Threading.Thread.Sleep(1000);
            }
            while (true)
            {
//                Console.WriteLine("Start " + ip + "/" + port);
                myClient = new LFSClient(ip, port, workingDir, iniFile, superUsers);
                startOk = true;
                
                myClient.doloop();

                if (!myClient.RestartProg)
                    break;
                myClient = null;
            }

        }
        private void openStbMode()
        {
            byte[] sstreq = myEncoder.SST();

            insimConnection = new InSim.Connect( myDebug );
            insimConnection.insimConnect( ip, port, password, "U", "LFSLapper", false, true);
            insimConnection.Send(sstreq, sstreq.Length);
            SendMsg("LFSLapper in Stand By State");
            insimConnection.waitReceive = false;
            // Get All Connections
            System.Threading.Thread.Sleep(100);
            byte[] ismncn = myEncoder.NCN();
            insimConnection.Send(ismncn, ismncn.Length);
            startOk = true;

        }
        private void closeStbMode(){
            insimConnection.Close();
        }
        public void start()
        {
            System.Globalization.CultureInfo oldCult = System.Threading.Thread.CurrentThread.CurrentCulture;
            System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");

            try
            {
                // Only to test Crash
                //                infoPlayer toto = null;
                //                toto.absangle = 1;
                if (this.autoStart == LapperServer.infoInstance.autoStartVal.AUTO_WORK)
                {
                    try
                    {
                        goWorkMode();
                    }
                    catch (System.Net.Sockets.SocketException ex )
                    {
                        throw (ex);
                    }
                    catch (InSim.Connect.ConnectException ex)
                    {
                        throw (ex);
                    }
                    catch (System.Exception ex)
                    {
                        Console.WriteLine("\nLapper Instance abort, Go in standBy mode. Look at log file :" + myDebug.getFileName("err"));
                        myDebug.printDateOnEachLine = false;
                        myDebug.WriteSeparator("err");
                        myDebug.WriteLineDate("err");
                        myDebug.WriteLine("err", "\nLapper Instance " + ip + "/" + port + " abort!");
                        myDebug.WriteLine("err", "");
                        myDebug.WriteLine("err", ex.Message);   // Print the error message.
                        myDebug.WriteLine("err", ex.Source);    // Name of application or object that caused the error.
                        myDebug.WriteLine("err", ex.StackTrace); //String that contains the stack trace for this exception.
                        myDebug.WriteLine("err", ex.TargetSite.ToString()); //String that contains the stack trace for this exception.
                        myDebug.WriteLine("err", "Closing Instance...");
                        myDebug.WriteSeparator("err");
                        myDebug.printDateOnEachLine = true;
                    }
                }
                startStbMode();
            }
            catch (System.Net.Sockets.SocketException)
            {
                myDebug.WriteLine("mss", "Connection unavailable or lost on " + ip + "/" + port + ", retry in 1mn");
                return;
            }
            catch (InSim.Connect.ConnectException)
            {
                Console.WriteLine("Connection unavailable or lost on " + ip + "/" + port + ", retry in 1mn");
                myDebug.WriteLine("mss", "Connection unavailable or lost on " + ip + "/" + port + ", retry in 1mn");
                return;
            }
            catch (System.Exception ex)
            {
                Console.WriteLine("\nLapper Instance abort. Look at log file :" + myDebug.getFileName("err"));
                myDebug.printDateOnEachLine = false;
                myDebug.WriteSeparator("err");
                myDebug.WriteLineDate("err");
                myDebug.WriteLine("err", "\nLapper Instance " + ip + "/" + port + " abort!");
                myDebug.WriteLine("err", "");
                myDebug.WriteLine("err", ex.Message);   // Print the error message.
                myDebug.WriteLine("err", ex.Source);    // Name of application or object that caused the error.
                myDebug.WriteLine("err", ex.StackTrace); //String that contains the stack trace for this exception.
                myDebug.WriteLine("err", ex.TargetSite.ToString()); //String that contains the stack trace for this exception.
                myDebug.WriteLine("err", "Closing Instance...");
                myDebug.WriteSeparator("err");
                myDebug.printDateOnEachLine = true;
                return;

            }
            finally
            {
                System.Threading.Thread.CurrentThread.CurrentCulture = oldCult;
            }
        }

        public void startStbMode(){
            userGroups ugroup = new userGroups( myDebug );
            System.Collections.Hashtable listOfPlayers = new System.Collections.Hashtable();
            int nbCnt = 0;
            byte[] recvPacket;
            byte[] stiny;

            openStbMode();
            while (true)
            {
                while (true)
                {
                    recvPacket = insimConnection.Receive();

                    if (TermProg == true)
                    {
                        SendMsg("LFSLapper Closed");
                        System.Threading.Thread.Sleep(1000);
                        return;
                    }
                    if (recvPacket != null)
                        break;
                    else
                    {
                        System.Threading.Thread.Sleep(100);
                        nbCnt++;
                        if (nbCnt > 10)
                        {
                            stiny = myEncoder.TINY_PING();
                            insimConnection.Send(stiny, stiny.Length);
                        }
                    }
                }
                nbCnt = 0;
                if (recvPacket.Length > 3)
                {
                    string packetHead = insimConnection.packetHead(recvPacket);
                    uint verifyID = insimConnection.verifyID(recvPacket);
                    switch (packetHead)
                    {
                        case "TINY"://confirm ack with ack
                            InSim.Decoder.TINY tiny = new InSim.Decoder.TINY(recvPacket);
                            switch (tiny.SubT)
                            {
                                case "TINY_NONE":
                                    stiny = myEncoder.TINY_NONE();
                                    insimConnection.Send(stiny, stiny.Length);
                                    break;
                            }
                            break;
                        case "NCN": // New Connection
                            InSim.Decoder.NCN newConnection = new InSim.Decoder.NCN(recvPacket);
                            listOfPlayers[newConnection.UCID] = newConnection.userName;
                            break;
                        case "CNL": // ConN Leave (end connection is moved down into this slot)
                            InSim.Decoder.CNL lostConnection = new InSim.Decoder.CNL(recvPacket);
                            if (listOfPlayers.ContainsKey(lostConnection.UCID))
                                listOfPlayers.Remove(lostConnection.UCID);
                            break;
                        case "MSO": // Message Output
                            InSim.Decoder.MSO mso = new InSim.Decoder.MSO(recvPacket);
                            if (mso.UserType == 1 || mso.UserType == 2)
                            {
                                if (mso.message.ToLower() == "!status")
                                {
                                    SendMsgToConnection(mso.UCID, "LFSLapper is on stand by state");
                                }
                                else if (mso.message.ToLower() == "!stop")
                                {
                                    SendMsgToConnection( mso.UCID, "LFS Lapper is already in stand by mode!");
                                }
                                else if(mso.message.ToLower() == "!start"){
                                    ugroup.addUserFromFile("superUsers", this.workingDir + "/" + this.superUsers);
                                    if (listOfPlayers.ContainsKey(mso.UCID) && ugroup.userExist("superUsers", (string)listOfPlayers[mso.UCID]))
                                    {
                                        SendMsgToConnection(mso.UCID, "Go to working mode!");

                                        closeStbMode();
                                        try
                                        {
                                            goWorkMode();
                                        }
                                        catch (System.Net.Sockets.SocketException ex)
                                        {
                                            throw (ex);
                                        }
                                        catch (InSim.Connect.ConnectException ex)
                                        {
                                            throw (ex);
                                        }
                                        catch (System.Exception ex)
                                        {
                                            Console.WriteLine("\nLapper Instance abort, Go in standBy mode. Look at log file :" + myDebug.getFileName("err"));
                                            myDebug.printDateOnEachLine = false;
                                            myDebug.WriteSeparator("err");
                                            myDebug.WriteLineDate("err");
                                            myDebug.WriteLine("err", "\nLapper Instance " + ip + "/" + port + " abort!");
                                            myDebug.WriteLine("err", "");
                                            myDebug.WriteLine("err", ex.Message);   // Print the error message.
                                            myDebug.WriteLine("err", ex.Source);    // Name of application or object that caused the error.
                                            myDebug.WriteLine("err", ex.StackTrace); //String that contains the stack trace for this exception.
                                            myDebug.WriteLine("err", ex.TargetSite.ToString()); //String that contains the stack trace for this exception.
                                            myDebug.WriteLine("err", "Closing Instance...");
                                            myDebug.WriteSeparator("err");
                                            myDebug.printDateOnEachLine = true;
                                        }
                                        openStbMode();

                                        SendMsgToConnection( mso.UCID, "LFSLapper in Stand By State");
                                    }
                                    else
                                    {
                                        SendMsgToConnection( mso.UCID, "Only for admin!");
                                    }
                                }
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}
