using System;
using System.Collections;
using System.Text;
using System.Threading;
using System.IO;


namespace LapperServer
{
    public enum LapperState
    {
        ST_STOP,		//  0					: Serveur not launched
        ST_TRY,	    	//  1 - instruction		: Serveur Try to connect
        ST_ALIVE,		//  2 - instruction		: Instance Started
    }

    public class infoInstance
    {
        public enum autoStartVal
        {
            AUTO_NONE,
            AUTO_STBY,
            AUTO_WORK,
        }
        public string name;
        public string groupId;
        public string ip;
        public int port;
        public string workingDir;
        public string iniFile;
        public LapperState state = LapperState.ST_STOP;
        public autoStartVal autoStart = autoStartVal.AUTO_NONE;
        public string password;

        public infoInstance(string pname, string pgroupId, string pip, int pport, string pworkingDir, string piniFile, autoStartVal pautoStart, LapperState pstate, string ppassword )
        {
            this.name = pname;
            this.groupId = pgroupId;
            this.ip = pip;
            this.port = pport;
            this.workingDir = pworkingDir;
            this.iniFile = piniFile;
            this.autoStart = pautoStart;
            this.state = pstate;
            this.password = ppassword;
        }
    }

    public class setOfLFSInstances
    {
        const int refreshIn = 10;
        public Hashtable activeLFSInstance = new Hashtable();
        static System.Timers.Timer timerManageInstances;
        Hashtable lastListOFLFSInstance = new Hashtable();
        private DateTime LFSServersLastWriteTime = DateTime.Now.AddDays(20);

        public setOfLFSInstances()
        {
            timerManageInstances = new System.Timers.Timer(1000);
            timerManageInstances.AutoReset = false;
            timerManageInstances.Elapsed += new System.Timers.ElapsedEventHandler(ManageInstances);
            timerManageInstances.Start();
        }
        public void stopAll()
        {
            foreach (DictionaryEntry de in activeLFSInstance)
            {
                LFSInstance currLFSInstance = (LFSInstance)de.Value;
                currLFSInstance.stop();
            }
            timerManageInstances.Stop();
            timerManageInstances.Dispose();

        }
        public infoInstance GetInfos(string idOfInstance)
        {
            Hashtable listOFLFSInstance = getListOfLFSInstanceFromFile();
            if (listOFLFSInstance.ContainsKey(idOfInstance) )
            {
                return (listOFLFSInstance[idOfInstance] as infoInstance);
            }
            return null;
        }
        public infoInstance Start(string idOfInstance)
        {
            Hashtable listOFLFSInstance = getListOfLFSInstanceFromFile();
            if (listOFLFSInstance.ContainsKey(idOfInstance) && !activeLFSInstance.ContainsKey(idOfInstance))
            {
                activeLFSInstance[idOfInstance] = new LFSInstance((infoInstance)listOFLFSInstance[idOfInstance]);
                (activeLFSInstance[idOfInstance] as LFSInstance).start();
                return (activeLFSInstance[idOfInstance] as LFSInstance).infos;
            }
            return null;
        }
        public infoInstance Stop(string idOfInstance)
        {
            if ( activeLFSInstance.ContainsKey(idOfInstance) )
            {
                LFSInstance tmp;
                tmp = (LFSInstance) activeLFSInstance[idOfInstance];
                tmp.stop();
                activeLFSInstance.Remove(idOfInstance);
                return tmp.infos;
            }
            else
            {
                return null;
            }
       }
        public bool waitForStartComplete(string idOfInstance, int timeOut)
        {
            if (activeLFSInstance.ContainsKey(idOfInstance))
            {
                LFSInstance tmp;
                tmp = (LFSInstance)activeLFSInstance[idOfInstance];
                return tmp.waitForStartComplete( timeOut );
            }
            else
            {
                return false;
            }
        }
        public bool isAlive(string idOfInstance)
        {
            if (activeLFSInstance.ContainsKey(idOfInstance))
            {
                LFSInstance tmp;
                tmp = (LFSInstance)activeLFSInstance[idOfInstance];
                return tmp.isAlive;
            }
            else
            {
                return false;
            }
        }
        public bool isStarted(string idOfInstance)
        {
            if (activeLFSInstance.ContainsKey(idOfInstance))
            {
                LFSInstance tmp;
                tmp = (LFSInstance)activeLFSInstance[idOfInstance];
                return tmp.started;
            }
            else
            {
                return false;
            }
        }

        public Hashtable getListOfLFSInstanceFromFile()
        {

            Hashtable listOfLFSInstance = new Hashtable();
            LapperState sta = LapperState.ST_STOP;
            string name = "";
            string workingDir = "";
            string iniFile = "";
            string password = "";

            if (!File.Exists("LFSServers.cfg"))
                throw (new System.Exception("Error LFSServers.cfg config file do not exist!"));
            {
                StreamReader sr = new StreamReader("LFSServers.cfg");
                while (!sr.EndOfStream)
                {

                    string line = sr.ReadLine();
                    if (line.Trim() == "")
                        continue;
                    if (line[0] == '#')
                        continue;
                    if (line.ToLower().IndexOf("remoteport") == 0)
                        continue;
                    line = line + "|||||";
                    string[] arg = line.Split('|');
                    // Find the password of the LFS Server
                    try
                    {
                        name = arg[0].ToString();
                        workingDir = arg[4].ToString();
                        iniFile = arg[5].ToString();
                        createWorkingDir(workingDir, iniFile);
                        infoInstance.autoStartVal autostart = infoInstance.autoStartVal.AUTO_NONE;
                        if (arg[6].ToLower() == "autostart")
                            autostart = infoInstance.autoStartVal.AUTO_STBY;
                        else if (arg[6].ToLower() == "autowork")
                            autostart = infoInstance.autoStartVal.AUTO_WORK;

                        sta = LapperState.ST_STOP;
                        if (this.isAlive( name ))
                            sta = LapperState.ST_ALIVE;
                        else if (this.isStarted(arg[0].ToString()))
                            sta = LapperState.ST_TRY;

                        try
                        {
                            LFSLapper.readIni myReadIni = new LFSLapper.readIni(workingDir, iniFile);
                            password = myReadIni.password;
                        }
                        catch
                        {
                            password = "";
                        }



                        listOfLFSInstance[arg[0]] = new infoInstance(arg[0], arg[1], arg[2], int.Parse(arg[3]), arg[4], arg[5], autostart,sta,password);
                    }
                    catch
                    {
                        throw (new System.Exception("Error in LFSServers.cfg file, wrong format"));
                    }

                }
                sr.Close();
            }
            return listOfLFSInstance;

        }
        void createWorkingDir(string workingDir, string iniFile )
        {
            if (!Directory.Exists(workingDir))
            {
                CopyDir("defaultfiles/workingdir", ".");
                Directory.Move("workingdir", workingDir);
                File.Delete(workingDir + "/defaultini.ini");
            }
            if( !File.Exists( workingDir + "/" + iniFile ) )
                File.Copy("defaultfiles/workingdir/defaultini.ini", workingDir + "/" + iniFile);
        }
        private void CopyDir(string sourceDir, string destDir)
        {
            DirectoryInfo dir = new DirectoryInfo(sourceDir); 
            if (dir.Exists)
            {
                string realDestDir;
                if (dir.Root.Name != dir.Name)
                {
                    realDestDir = Path.Combine(destDir, dir.Name);
                    if (!Directory.Exists(realDestDir))
                        Directory.CreateDirectory(realDestDir);
                }
                else realDestDir = destDir;
                foreach (string d in Directory.GetDirectories(sourceDir))
                    CopyDir(d, realDestDir);
                foreach (string file in Directory.GetFiles(sourceDir))
                {

                    string fileNameDest = Path.Combine(realDestDir, Path.GetFileName(file));
                    //if (!File.Exists(fileNameDest))

                    File.Copy(file, fileNameDest, true);
                }
            }
        }


        void ManageInstances(object sender, System.Timers.ElapsedEventArgs e)
        {
            System.Globalization.CultureInfo oldCult = System.Threading.Thread.CurrentThread.CurrentCulture;
            System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");

            FileInfo f = new FileInfo("LFSServers.cfg");
            if( f.LastWriteTime != LFSServersLastWriteTime ) 
            {
                LFSServersLastWriteTime = f.LastWriteTime;

                Hashtable listOFLFSInstance = getListOfLFSInstanceFromFile();
                ArrayList toRemove = new ArrayList();
                // Remove instance deleted in config file
                foreach (DictionaryEntry de in activeLFSInstance)
                {
                    LFSInstance currLFSInstance = (LFSInstance)de.Value;
                    //Removed entry from list file
                    if (!listOFLFSInstance.ContainsKey(currLFSInstance.infos.name))
                    {
                        currLFSInstance.stop();
                        toRemove.Add(currLFSInstance.infos.name);
                    }
                }
                for (int i = 0; i < toRemove.Count; i++)
                    activeLFSInstance.Remove((string)toRemove[i]);

                // Add new instance in config file
                foreach (DictionaryEntry de in listOFLFSInstance)
                {
                    infoInstance myInfos = (infoInstance)de.Value;
                    if (myInfos.autoStart != infoInstance.autoStartVal.AUTO_NONE && !lastListOFLFSInstance.ContainsKey(myInfos.name))
                    {
                        this.Start(myInfos.name);
                    }
                }
                lastListOFLFSInstance = (Hashtable) listOFLFSInstance.Clone();
            }
// Find All command from all client
            foreach (DictionaryEntry de in activeLFSInstance)
            {
                LFSInstance currLFSInstance = (LFSInstance)de.Value;
                if (currLFSInstance.isAlive && currLFSInstance.myListen.myClient != null)
                {
                    try
                    {
                        string outCmd = (string)currLFSInstance.myListen.myClient.outgoingCmdStack.Pop();
                        sendCmdToGroupOfInstance(currLFSInstance.infos.groupId, outCmd);
                    }
                    catch
                    {
                    }
                }
            }

            foreach (DictionaryEntry de in activeLFSInstance)
            {
                LFSInstance currLFSInstance = ( LFSInstance )de.Value;
                if (currLFSInstance.isAlive == false)
                {
                    if (currLFSInstance.myListen != null && currLFSInstance.myListen.TermProg == true)
                    {
                        currLFSInstance.started = false;
                    }
                    currLFSInstance.myListen = null;
                    if (currLFSInstance.started)
                        currLFSInstance.createAndStart( );
                }
            }
            System.Threading.Thread.CurrentThread.CurrentCulture = oldCult;
            timerManageInstances.Start();
        }

        public void sendCmdToGroupOfInstance(string group, string cmd)
        {
            foreach (DictionaryEntry de in activeLFSInstance)
            {
                LFSInstance currLFSInstance = (LFSInstance)de.Value;
                if (currLFSInstance.isAlive && currLFSInstance.myListen.myClient != null)
                {
                    if (group == "" || group == currLFSInstance.infos.groupId)
                        currLFSInstance.myListen.myClient.incommingCmdStack.Push(cmd);
                }
            }

        }
    }
    class LFSInstance
    {
        public bool started = false;
        public infoInstance infos;
        private int nbStart = 0;
        DateTime lasStart = DateTime.Now.AddSeconds(-100);
        public LFSLapper.LFSListen.Listen myListen;
        Thread myThread;


        public LFSInstance( infoInstance pinfos )
        {
            infos = pinfos;
        }
        public void start()
        {
            this.started = true;
        }

        public bool waitForStartComplete(int timeOut)
        {
            DateTime tmout = DateTime.Now.AddSeconds(timeOut);
            System.Threading.Thread.Sleep(2000);
            while (true)
            {
                if (DateTime.Now > tmout)
                    return false;
                if (myListen == null)
                {
                    return false;
                }
                if (myListen.startOk)
                {
                    return true;
                }
                System.Threading.Thread.Sleep(100);
            }
        }
        public void createAndStart( )
        {
            string password = "";
            string superUsers = "";
            if (DateTime.Now < lasStart.AddSeconds(60))
                return;
            nbStart++;
            lasStart = DateTime.Now;
            try
            {
                try
                {
                    LFSLapper.readIni myReadIni = new LFSLapper.readIni(this.infos.workingDir, this.infos.iniFile);
                    password = myReadIni.password;
                    superUsers = myReadIni.superUsers;
                }
                catch
                {
                    password = "";
                    superUsers = "";
                }

                myListen = new LFSLapper.LFSListen.Listen(this.infos.autoStart, this.infos.ip, this.infos.port, password, this.infos.workingDir, this.infos.iniFile, superUsers);
            }
            catch
            {
                myListen = null;
                return;
            }
            myThread = new Thread(new ThreadStart(myListen.start));
            myThread.Start();
            this.started = true;
        }

        public void stop()
        {
            nbStart = 0;
            if (isAlive)
            {
                if (myListen.myClient != null) // Stop Lapper Instance
                {
                    myListen.myClient.TermProg = true;
                }
                myListen.TermProg = true; // Then Stop Thread Listen
                myThread.Join();
            }
            myListen = null;
            System.GC.Collect();
            this.started = false;
            this.lasStart = DateTime.Now.AddSeconds(-100);
        }
        public bool isAlive
        {
            get
            {
                if (myThread != null)
                    return myThread.IsAlive;
                return false;
            }


        }

    }
}
