using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace LFSLapper
{
    class readIni
    {
        public string password = "";
        public string configFile = "";
        public string superUsers = "";
        public readIni(string pWorkinfDir, string pIniFile)
        {
            string fileIni = pWorkinfDir + "/" + pIniFile;
            StreamReader sr = new StreamReader(fileIni);
            while (!sr.EndOfStream)
            {
                string line = sr.ReadLine();
                if (line.Trim() == "")
                    continue;
                if (line[0] == '#')
                    continue;
                try
                {
                    string[] arg = line.Split('=');
                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$password")
                        this.password = arg[1].Replace(';',' ').Replace('"',' ').Trim();
                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$configfile")
                        this.configFile = arg[1].Replace(';', ' ').Replace('"', ' ').Trim();
                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$superusersfile")
                        this.superUsers = arg[1].Replace(';', ' ').Replace('"', ' ').Trim();
                }
                catch
                {
                    throw (new System.Exception("Error in " + pIniFile + " config file, wrong format"));
                }
            }
            sr.Close();
        }
    }
}
